/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.PropertyDescriptorDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;

public class FlowRegistryClientEntityMerger
implements ComponentEntityMerger<FlowRegistryClientEntity> {
    @Override
    public void mergeComponents(FlowRegistryClientEntity clientEntity, Map<NodeIdentifier, FlowRegistryClientEntity> entityMap) {
        FlowRegistryClientDTO clientDTO = clientEntity.getComponent();
        HashMap<NodeIdentifier, FlowRegistryClientDTO> dtoMap = new HashMap<NodeIdentifier, FlowRegistryClientDTO>();
        for (Map.Entry<NodeIdentifier, FlowRegistryClientEntity> entry : entityMap.entrySet()) {
            FlowRegistryClientEntity flowRegistryClientEntity = entry.getValue();
            FlowRegistryClientDTO flowRegistryClientDTO = flowRegistryClientEntity.getComponent();
            dtoMap.put(entry.getKey(), flowRegistryClientDTO);
        }
        this.mergeDtos(clientDTO, dtoMap);
    }

    private void mergeDtos(FlowRegistryClientDTO clientDto, Map<NodeIdentifier, FlowRegistryClientDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap propertyDescriptorMap = new HashMap();
        for (Map.Entry<NodeIdentifier, FlowRegistryClientDTO> nodeEntry : dtoMap.entrySet()) {
            FlowRegistryClientDTO nodEntryClient = nodeEntry.getValue();
            if (nodEntryClient == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodEntryClient.getValidationErrors());
            if (nodEntryClient.getDescriptors() == null) continue;
            nodEntryClient.getDescriptors().values().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeId, propertyDescriptor));
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientDto.getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        Set<String> validationStatuses = dtoMap.values().stream().map(FlowRegistryClientDTO::getValidationStatus).collect(Collectors.toSet());
        clientDto.setValidationStatus(ErrorMerger.mergeValidationStatus(validationStatuses));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

