/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.RemoteProcessGroupsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;

public class RemoteProcessGroupsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern REMOTE_PROCESS_GROUPS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/remote-process-groups");
    public static final Pattern REMOTE_PROCESS_GROUPS_RUN_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/remote-process-groups/process-group/[a-f0-9\\-]{36}/run-status");

    @Override
    public boolean canHandle(URI uri, String method) {
        if ("GET".equalsIgnoreCase(method) && REMOTE_PROCESS_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "PUT".equalsIgnoreCase(method) && REMOTE_PROCESS_GROUPS_RUN_STATUS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        RemoteProcessGroupsEntity responseEntity = (RemoteProcessGroupsEntity)clientResponse.getClientResponse().readEntity(RemoteProcessGroupsEntity.class);
        Set rpgEntities = responseEntity.getRemoteProcessGroups();
        if (rpgEntities != null) {
            HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>>();
            for (NodeResponse nodeResponse : successfulResponses) {
                RemoteProcessGroupsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (RemoteProcessGroupsEntity)nodeResponse.getClientResponse().readEntity(RemoteProcessGroupsEntity.class);
                Set nodeRpgEntities = nodeResponseEntity.getRemoteProcessGroups();
                if (nodeRpgEntities == null) continue;
                for (RemoteProcessGroupEntity nodeRpgEntity : nodeRpgEntities) {
                    Map innerMap = entityMap.computeIfAbsent(nodeRpgEntity.getId(), k -> new HashMap());
                    innerMap.put(nodeResponse.getNodeId(), nodeRpgEntity);
                }
            }
            RemoteProcessGroupsEntityMerger.mergeRemoteProcessGroups(rpgEntities, entityMap);
        }
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

