/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.AffectedComponentEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.VariableDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;

public class VariableRegistryEndpointMerger
extends AbstractSingleEntityEndpoint<VariableRegistryEntity>
implements EndpointResponseMerger {
    public static final Pattern VARIABLE_REGISTRY_UPDATE_REQUEST_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/variable-registry");
    private final AffectedComponentEntityMerger affectedComponentEntityMerger = new AffectedComponentEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && VARIABLE_REGISTRY_UPDATE_REQUEST_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<VariableRegistryEntity> getEntityClass() {
        return VariableRegistryEntity.class;
    }

    @Override
    protected void mergeResponses(VariableRegistryEntity clientEntity, Map<NodeIdentifier, VariableRegistryEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        VariableRegistryDTO clientVariableRegistry = clientEntity.getVariableRegistry();
        Set clientVariableEntities = clientVariableRegistry.getVariables();
        if (clientVariableEntities != null) {
            Iterator i = clientVariableEntities.iterator();
            while (i.hasNext()) {
                VariableEntity clientVariableEntity = (VariableEntity)i.next();
                VariableDTO clientVariable = clientVariableEntity.getVariable();
                HashMap<NodeIdentifier, Set<AffectedComponentEntity>> nodeAffectedComponentEntities = new HashMap<NodeIdentifier, Set<AffectedComponentEntity>>();
                boolean retainClientVariable = true;
                for (Map.Entry<NodeIdentifier, VariableRegistryEntity> nodeEntry : entityMap.entrySet()) {
                    VariableRegistryEntity nodeVariableRegistry = nodeEntry.getValue();
                    Set nodeVariableEntities = nodeVariableRegistry.getVariableRegistry().getVariables();
                    if (nodeVariableEntities == null) {
                        retainClientVariable = false;
                        break;
                    }
                    boolean variableFound = false;
                    for (VariableEntity nodeVariableEntity : nodeVariableEntities) {
                        VariableDTO nodeVariable = nodeVariableEntity.getVariable();
                        if (!clientVariable.getProcessGroupId().equals(nodeVariable.getProcessGroupId()) || !clientVariable.getName().equals(nodeVariable.getName())) continue;
                        variableFound = true;
                        if (Boolean.FALSE.equals(nodeVariableEntity.getCanWrite())) {
                            clientVariableEntity.setCanWrite(Boolean.valueOf(false));
                        }
                        nodeAffectedComponentEntities.put(nodeEntry.getKey(), nodeVariableEntity.getVariable().getAffectedComponents());
                        break;
                    }
                    if (variableFound) continue;
                    retainClientVariable = false;
                    break;
                }
                if (!retainClientVariable) {
                    i.remove();
                    continue;
                }
                Set clientAffectedComponentEntities = clientVariableEntity.getVariable().getAffectedComponents();
                this.affectedComponentEntityMerger.mergeAffectedComponents(clientAffectedComponentEntities, nodeAffectedComponentEntities);
            }
        }
    }
}

