/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.cluster.protocol.ProtocolContext;
import org.apache.nifi.cluster.protocol.ProtocolMessageMarshaller;
import org.apache.nifi.cluster.protocol.ProtocolMessageUnmarshaller;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;

public class JaxbProtocolContext<T>
implements ProtocolContext<T> {
    private static final int BUF_SIZE = (int)Math.pow(2.0, 10.0);
    private static final byte MESSAGE_PROTOCOL_START_SENTINEL = 90;
    private final JAXBContext jaxbCtx;

    public JaxbProtocolContext(JAXBContext jaxbCtx) {
        this.jaxbCtx = jaxbCtx;
    }

    @Override
    public ProtocolMessageMarshaller<T> createMarshaller() {
        return new ProtocolMessageMarshaller<T>(){

            @Override
            public void marshal(T msg, OutputStream os) throws IOException {
                try {
                    Marshaller marshaller = JaxbProtocolContext.this.jaxbCtx.createMarshaller();
                    ByteArrayOutputStream msgBytes = new ByteArrayOutputStream();
                    marshaller.marshal(msg, (OutputStream)msgBytes);
                    DataOutputStream dos = new DataOutputStream(os);
                    dos.write(90);
                    dos.writeInt(msgBytes.size());
                    msgBytes.writeTo(dos);
                    dos.flush();
                }
                catch (JAXBException je) {
                    throw new IOException("Failed marshalling protocol message due to: " + je, je);
                }
            }
        };
    }

    @Override
    public ProtocolMessageUnmarshaller<T> createUnmarshaller() {
        return new ProtocolMessageUnmarshaller<T>(){

            @Override
            public T unmarshal(InputStream is) throws IOException {
                try {
                    int bytesToRead;
                    DataInputStream dis = new DataInputStream(is);
                    byte sentinel = (byte)dis.read();
                    if (sentinel == -1) {
                        throw new EOFException();
                    }
                    if (90 != sentinel) {
                        throw new IOException("Failed reading protocol message due to malformed header");
                    }
                    int msgBytesSize = dis.readInt();
                    ByteBuffer buffer = ByteBuffer.allocate(msgBytesSize);
                    int totalBytesRead = 0;
                    do {
                        bytesToRead = msgBytesSize - totalBytesRead >= BUF_SIZE ? BUF_SIZE : msgBytesSize - totalBytesRead;
                    } while ((totalBytesRead += dis.read(buffer.array(), totalBytesRead, bytesToRead)) < msgBytesSize);
                    Unmarshaller unmarshaller = JaxbProtocolContext.this.jaxbCtx.createUnmarshaller();
                    byte[] msg = new byte[totalBytesRead];
                    buffer.get(msg);
                    StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                    XMLStreamReader xsr = provider.getStreamReader(new StreamSource(new ByteArrayInputStream(msg)));
                    return unmarshaller.unmarshal(xsr);
                }
                catch (JAXBException | ProcessingException e) {
                    throw new IOException("Failed unmarshalling protocol message due to: " + (Exception)e, e);
                }
            }
        };
    }
}

