/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.DataFlowAdapter;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@XmlJavaTypeAdapter(value=DataFlowAdapter.class)
public class StandardDataFlow
implements Serializable,
DataFlow {
    private static final Logger logger = LoggerFactory.getLogger(StandardDataFlow.class);
    private static final long serialVersionUID = 1L;
    private final byte[] flow;
    private final byte[] snippetBytes;
    private final byte[] authorizerFingerprint;
    private final Set<String> missingComponentIds;
    private Document flowDocument;
    private VersionedDataflow versionedDataflow;

    public StandardDataFlow(byte[] flow, byte[] snippetBytes, byte[] authorizerFingerprint, Set<String> missingComponentIds) {
        if (flow == null) {
            throw new NullPointerException("Flow cannot be null");
        }
        this.flow = flow;
        this.snippetBytes = snippetBytes;
        this.authorizerFingerprint = authorizerFingerprint;
        this.missingComponentIds = Collections.unmodifiableSet(missingComponentIds == null ? new HashSet() : new HashSet<String>(missingComponentIds));
    }

    public StandardDataFlow(DataFlow toCopy) {
        this.flow = StandardDataFlow.copy(toCopy.getFlow());
        this.snippetBytes = StandardDataFlow.copy(toCopy.getSnippets());
        this.authorizerFingerprint = StandardDataFlow.copy(toCopy.getAuthorizerFingerprint());
        this.missingComponentIds = Collections.unmodifiableSet(toCopy.getMissingComponents() == null ? new HashSet() : new HashSet(toCopy.getMissingComponents()));
    }

    private static byte[] copy(byte[] bytes) {
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] getFlow() {
        return this.flow;
    }

    public synchronized Document getFlowDocument() {
        if (this.flowDocument == null) {
            this.flowDocument = StandardDataFlow.parseFlowBytes(this.flow);
        }
        return this.flowDocument;
    }

    public synchronized VersionedDataflow getVersionedDataflow() {
        if (this.versionedDataflow == null) {
            this.versionedDataflow = this.parseVersionedDataflow(this.flow);
        }
        return this.versionedDataflow;
    }

    public byte[] getSnippets() {
        return this.snippetBytes;
    }

    public byte[] getAuthorizerFingerprint() {
        return this.authorizerFingerprint;
    }

    public Set<String> getMissingComponents() {
        return this.missingComponentIds;
    }

    private static Document parseFlowBytes(byte[] flow) throws FlowSerializationException {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            documentProvider.setNamespaceAware(true);
            documentProvider.setErrorHandler((ErrorHandler)new DefaultHandler(){

                @Override
                public void error(SAXParseException e) {
                    logger.warn("Schema validation error parsing Flow Configuration at line {}, col {}: {}", new Object[]{e.getLineNumber(), e.getColumnNumber(), e.getMessage()});
                }
            });
            return documentProvider.parse((InputStream)new ByteArrayInputStream(flow));
        }
        catch (ProcessingException e) {
            throw new FlowSerializationException("Flow parsing failed", (Throwable)e);
        }
    }

    private VersionedDataflow parseVersionedDataflow(byte[] flow) {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(objectMapper.getTypeFactory()));
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.getFactory().setStreamReadConstraints(streamReadConstraints);
            return (VersionedDataflow)objectMapper.readValue(flow, VersionedDataflow.class);
        }
        catch (Exception e) {
            throw new FlowSerializationException("Could not parse flow as a VersionedDataflow", (Throwable)e);
        }
    }

    public boolean isXml() {
        if (this.flow == null || this.flow.length == 0) {
            return true;
        }
        return this.flow[0] == 60;
    }
}

