/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.jaxb.message.HeartbeatAdapter;

@XmlJavaTypeAdapter(value=HeartbeatAdapter.class)
public class Heartbeat {
    private final NodeIdentifier nodeIdentifier;
    private final NodeConnectionStatus connectionStatus;
    private final long createdTimestamp;
    private final byte[] payload;

    public Heartbeat(NodeIdentifier nodeIdentifier, NodeConnectionStatus connectionStatus, byte[] payload) {
        if (nodeIdentifier == null) {
            throw new IllegalArgumentException("Node Identifier may not be null.");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.connectionStatus = connectionStatus;
        this.payload = payload;
        this.createdTimestamp = new Date().getTime();
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public NodeConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @XmlTransient
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }
}

