/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.util.FlowFileUnpackager;

public class FlowFileUnpackagerV2
implements FlowFileUnpackager {
    private final byte[] readBuffer = new byte[8192];
    private Map<String, String> nextAttributes = null;
    private boolean haveReadSomething = false;

    @Override
    public boolean hasMoreData() throws IOException {
        return this.nextAttributes != null || !this.haveReadSomething;
    }

    protected Map<String, String> readAttributes(InputStream in) throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Integer numAttributes = this.readFieldLength(in);
        if (numAttributes == null) {
            return null;
        }
        if (numAttributes == 0) {
            throw new IOException("flow files cannot have zero attributes");
        }
        for (int i = 0; i < numAttributes; ++i) {
            String key = this.readString(in);
            String value = this.readString(in);
            attributes.put(key, value);
        }
        return attributes;
    }

    @Override
    public Map<String, String> unpackageFlowFile(InputStream in, OutputStream out) throws IOException {
        Map<String, String> attributes = this.nextAttributes != null ? this.nextAttributes : this.readAttributes(in);
        long expectedNumBytes = this.readLong(in);
        this.copy(in, out, expectedNumBytes);
        this.nextAttributes = this.readAttributes(in);
        this.haveReadSomething = true;
        return attributes;
    }

    protected String readString(InputStream in) throws IOException {
        Integer numBytes = this.readFieldLength(in);
        if (numBytes == null) {
            throw new EOFException();
        }
        byte[] bytes = new byte[numBytes.intValue()];
        this.fillBuffer(in, bytes, numBytes);
        return new String(bytes, "UTF-8");
    }

    private void fillBuffer(InputStream in, byte[] buffer, int length) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while ((bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead)) > 0) {
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead != length) {
            throw new EOFException();
        }
    }

    protected long copy(InputStream in, OutputStream out, long numBytes) throws IOException {
        int bytesRead;
        long totalBytesRead = 0L;
        while ((bytesRead = in.read(this.readBuffer, 0, (int)Math.min((long)this.readBuffer.length, numBytes - totalBytesRead))) > 0) {
            out.write(this.readBuffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        if (totalBytesRead < numBytes) {
            throw new EOFException("Expected " + numBytes + " but received " + totalBytesRead);
        }
        return totalBytesRead;
    }

    protected long readLong(InputStream in) throws IOException {
        this.fillBuffer(in, this.readBuffer, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
    }

    private Integer readFieldLength(InputStream in) throws IOException {
        int firstValue = in.read();
        int secondValue = in.read();
        if (firstValue < 0) {
            return null;
        }
        if (secondValue < 0) {
            throw new EOFException();
        }
        if (firstValue == 255 && secondValue == 255) {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        return (firstValue << 8) + secondValue;
    }
}

