/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.encryptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.encryptor.AbstractFlowEncryptor;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;
import org.apache.nifi.xml.processing.stream.XMLEventReaderProvider;

public class XmlFlowEncryptor
extends AbstractFlowEncryptor {
    private static final XMLEventReaderProvider eventReaderProvider = new StandardXMLEventReaderProvider();

    @Override
    public void processFlow(InputStream inputStream, OutputStream outputStream, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        try {
            XMLEventReader reader = eventReaderProvider.getEventReader(new StreamSource(inputStream));
            XMLEventWriter writer = xmlOutputFactory.createXMLEventWriter(outputStream, StandardCharsets.UTF_8.name());
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.getEventType() == 4) {
                    Characters characters = event.asCharacters();
                    String value = characters.getData();
                    Matcher matcher = ENCRYPTED_PATTERN.matcher(value);
                    if (matcher.matches()) {
                        String processedValue = this.getOutputEncrypted(matcher.group(1), inputEncryptor, outputEncryptor);
                        writer.add(eventFactory.createCharacters(processedValue));
                        continue;
                    }
                    writer.add(characters);
                    continue;
                }
                if (event.getEventType() == 7) {
                    writer.add(event);
                    writer.add(eventFactory.createSpace(System.lineSeparator()));
                    continue;
                }
                writer.add(event);
            }
            writer.flush();
            writer.close();
            reader.close();
            outputStream.close();
            inputStream.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Flow XML Processing Failed", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed Processing Flow Configuration", e);
        }
    }
}

