/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.EvaluatorState;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class MultiNamedAttributeEvaluator
extends MultiAttributeEvaluator {
    private final List<String> attributeNames;
    private final int evaluationType;

    public MultiNamedAttributeEvaluator(List<String> attributeNames, int evaluationType) {
        this.attributeNames = attributeNames;
        this.evaluationType = evaluationType;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        State state = evaluationContext.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluationContext.getEvaluatorState().putState(this, state);
        }
        state.matchingAttributeNames = new ArrayList<String>(this.attributeNames);
        if (state.matchingAttributeNames.size() <= state.evaluationCount) {
            return new StringQueryResult(null);
        }
        return new StringQueryResult(evaluationContext.getExpressionValue(state.matchingAttributeNames.get(state.evaluationCount++)));
    }

    @Override
    public int getEvaluationsRemaining(EvaluationContext context) {
        EvaluatorState evaluatorState = context.getEvaluatorState();
        State state = evaluatorState.getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluatorState.putState(this, state);
        }
        return state.matchingAttributeNames.size() - state.evaluationCount;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    private class State {
        private int evaluationCount = 0;
        private List<String> matchingAttributeNames = null;

        private State() {
        }
    }
}

