/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeWithToken;

public class ProcessingInstructionDataNode
extends BxmlNodeWithToken {
    private final int stringLength;
    private final int tagLength;
    private final String data;

    public ProcessingInstructionDataNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        this.stringLength = binaryReader.readWord();
        this.tagLength = 3 + 2 * this.stringLength;
        this.data = this.stringLength > 0 ? binaryReader.readWString(this.stringLength) : "";
        this.init();
    }

    public String getValue() {
        return this.data + "?>";
    }

    @Override
    protected List<BxmlNode> initChildren() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

