/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.bxml.AttributeNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.CDataSectionNode;
import org.apache.nifi.processors.evtx.parser.bxml.ConditionalSubstitutionNode;
import org.apache.nifi.processors.evtx.parser.bxml.EntityReferenceNode;
import org.apache.nifi.processors.evtx.parser.bxml.NormalSubstitutionNode;
import org.apache.nifi.processors.evtx.parser.bxml.OpenStartElementNode;
import org.apache.nifi.processors.evtx.parser.bxml.RootNode;
import org.apache.nifi.processors.evtx.parser.bxml.TemplateInstanceNode;
import org.apache.nifi.processors.evtx.parser.bxml.TemplateNode;
import org.apache.nifi.processors.evtx.parser.bxml.ValueNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.BXmlTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;

public class XmlBxmlNodeVisitor
implements BxmlNodeVisitor {
    private final XMLStreamWriter xmlStreamWriter;
    private List<VariantTypeNode> substitutions;

    public XmlBxmlNodeVisitor(XMLStreamWriter xmlStreamWriter, RootNode rootNode) throws IOException {
        this.xmlStreamWriter = xmlStreamWriter;
        this.substitutions = rootNode.getSubstitutions();
        for (BxmlNode bxmlNode : rootNode.getChildren()) {
            bxmlNode.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(OpenStartElementNode openStartElementNode) throws IOException {
        try {
            this.xmlStreamWriter.writeStartElement(openStartElementNode.getTagName());
            try {
                ArrayList<BxmlNode> nonAttributeChildren = new ArrayList<BxmlNode>();
                for (BxmlNode bxmlNode : openStartElementNode.getChildren()) {
                    if (bxmlNode instanceof AttributeNode) {
                        bxmlNode.accept(this);
                        continue;
                    }
                    nonAttributeChildren.add(bxmlNode);
                }
                for (BxmlNode nonAttributeChild : nonAttributeChildren) {
                    nonAttributeChild.accept(this);
                }
            }
            finally {
                this.xmlStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void visit(AttributeNode attributeNode) throws IOException {
        try {
            AttributeNodeVisitor attributeNodeVisitor = new AttributeNodeVisitor();
            attributeNodeVisitor.visit(attributeNode);
            this.xmlStreamWriter.writeAttribute(attributeNode.getAttributeName(), attributeNodeVisitor.getValue());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void visit(TemplateInstanceNode templateInstanceNode) throws IOException {
        templateInstanceNode.getTemplateNode().accept(this);
    }

    @Override
    public void visit(TemplateNode templateNode) throws IOException {
        for (BxmlNode bxmlNode : templateNode.getChildren()) {
            bxmlNode.accept(this);
        }
    }

    @Override
    public void visit(RootNode rootNode) throws IOException {
        new XmlBxmlNodeVisitor(this.xmlStreamWriter, rootNode);
    }

    @Override
    public void visit(CDataSectionNode cDataSectionNode) throws IOException {
        try {
            this.xmlStreamWriter.writeCData(cDataSectionNode.getCdata());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void visit(EntityReferenceNode entityReferenceNode) throws IOException {
        try {
            this.xmlStreamWriter.writeCharacters(entityReferenceNode.getValue());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void visit(ValueNode valueNode) throws IOException {
        for (BxmlNode bxmlNode : valueNode.getChildren()) {
            bxmlNode.accept(this);
        }
    }

    @Override
    public void visit(ConditionalSubstitutionNode conditionalSubstitutionNode) throws IOException {
        this.substitutions.get(conditionalSubstitutionNode.getIndex()).accept(this);
    }

    @Override
    public void visit(NormalSubstitutionNode normalSubstitutionNode) throws IOException {
        this.substitutions.get(normalSubstitutionNode.getIndex()).accept(this);
    }

    @Override
    public void visit(VariantTypeNode variantTypeNode) throws IOException {
        try {
            if (variantTypeNode instanceof BXmlTypeNode) {
                ((BXmlTypeNode)variantTypeNode).getRootNode().accept(this);
            } else {
                this.xmlStreamWriter.writeCharacters(variantTypeNode.getValue());
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private class AttributeNodeVisitor
    implements BxmlNodeVisitor {
        private String value;

        private AttributeNodeVisitor() {
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public void visit(AttributeNode attributeNode) throws IOException {
            attributeNode.getValue().accept(this);
        }

        @Override
        public void visit(ValueNode valueNode) throws IOException {
            for (BxmlNode bxmlNode : valueNode.getChildren()) {
                bxmlNode.accept(this);
            }
        }

        @Override
        public void visit(VariantTypeNode variantTypeNode) throws IOException {
            this.value = variantTypeNode.getValue();
        }

        @Override
        public void visit(NormalSubstitutionNode normalSubstitutionNode) throws IOException {
            this.value = XmlBxmlNodeVisitor.this.substitutions.get(normalSubstitutionNode.getIndex()).getValue();
        }

        @Override
        public void visit(ConditionalSubstitutionNode conditionalSubstitutionNode) throws IOException {
            this.value = XmlBxmlNodeVisitor.this.substitutions.get(conditionalSubstitutionNode.getIndex()).getValue();
        }
    }
}

