/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;

public class NameStringNode
extends BxmlNode {
    private final UnsignedInteger nextOffset;
    private final int hash;
    private final String string;
    private final int stringLength;

    public NameStringNode(BinaryReader binaryReader, ChunkHeader chunkHeader) throws IOException {
        super(binaryReader, chunkHeader, null);
        this.nextOffset = binaryReader.readDWord();
        this.hash = binaryReader.readWord();
        this.stringLength = binaryReader.readWord();
        this.string = binaryReader.readWString(this.stringLength);
        binaryReader.skip(2);
        this.init();
    }

    public UnsignedInteger getNextOffset() {
        return this.nextOffset;
    }

    public int getHash() {
        return this.hash;
    }

    public String getString() {
        return this.string;
    }

    @Override
    protected List<BxmlNode> initChildren() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

