/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.util.Date;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.Block;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.RootNode;

public class Record
extends Block {
    private final int magicNumber;
    private final int size;
    private final UnsignedLong recordNum;
    private final Date timestamp;
    private final RootNode rootNode;
    private final int size2;

    public Record(BinaryReader binaryReader, ChunkHeader chunkHeader) throws IOException {
        super(binaryReader, chunkHeader.getOffset() + (long)binaryReader.getPosition());
        this.magicNumber = NumberUtil.intValueExpected((Number)binaryReader.readDWord(), 10794, "Invalid magic number.", new Object[0]);
        this.size = NumberUtil.intValueMax(binaryReader.readDWord(), 65536, "Invalid size.", new Object[0]);
        this.recordNum = binaryReader.readQWord();
        this.timestamp = binaryReader.readFileTime();
        this.rootNode = new RootNode(binaryReader, chunkHeader, null);
        int desiredPosition = this.getInitialPosition() + this.size - 4;
        int skipAmount = desiredPosition - binaryReader.getPosition();
        if (skipAmount > 0) {
            binaryReader.skip(skipAmount);
        }
        this.size2 = NumberUtil.intValueExpected((Number)binaryReader.readDWord(), this.size, "Size 2 doesn't match.", new Object[0]);
    }

    public String toString() {
        return "Record{magicNumber=" + this.magicNumber + ", size=" + this.size + ", recordNum=" + this.recordNum + ", timestamp=" + this.timestamp + ", rootNode=" + this.rootNode + ", size2=" + this.size2 + "}";
    }

    public UnsignedLong getRecordNum() {
        return this.recordNum;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }
}

