/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx;

import com.google.common.net.MediaType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class MalformedChunkHandler {
    private final Relationship badChunkRelationship;

    public MalformedChunkHandler(Relationship badChunkRelationship) {
        this.badChunkRelationship = badChunkRelationship;
    }

    public void handle(FlowFile original, ProcessSession processSession, String chunkName, byte[] badChunk) {
        FlowFile flowFile = processSession.create(original);
        flowFile = processSession.putAttribute(flowFile, CoreAttributes.FILENAME.key(), chunkName);
        flowFile = processSession.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), MediaType.APPLICATION_BINARY.toString());
        flowFile = processSession.write(flowFile, out -> out.write(badChunk));
        processSession.transfer(flowFile, this.badChunkRelationship);
    }
}

