/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.event.transport.SslSessionStatus;
import org.apache.nifi.event.transport.message.ByteArrayMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketByteArrayMessageDecoder
extends MessageToMessageDecoder<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(SocketByteArrayMessageDecoder.class);

    protected void decode(ChannelHandlerContext channelHandlerContext, byte[] bytes, List<Object> decoded) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
        String address = remoteAddress.getHostString();
        SslSessionStatus sslSessionStatus = this.getSslSessionStatus(channelHandlerContext);
        ByteArrayMessage message = new ByteArrayMessage(bytes, address, sslSessionStatus);
        decoded.add(message);
    }

    private SslSessionStatus getSslSessionStatus(ChannelHandlerContext channelHandlerContext) {
        SslHandler sslHandler = null;
        for (Map.Entry entry : channelHandlerContext.channel().pipeline()) {
            ChannelHandler channelHandler = (ChannelHandler)entry.getValue();
            if (!(channelHandler instanceof SslHandler)) continue;
            sslHandler = (SslHandler)channelHandler;
            break;
        }
        return sslHandler == null ? null : this.createSslSessionStatusFromSslHandler(sslHandler);
    }

    private SslSessionStatus createSslSessionStatusFromSslHandler(SslHandler sslHandler) {
        SSLSession sslSession = sslHandler.engine().getSession();
        SslSessionStatus sslSessionStatus = null;
        try {
            Certificate[] certificates = sslSession.getPeerCertificates();
            if (certificates.length > 0) {
                X509Certificate certificate = (X509Certificate)certificates[0];
                X500Principal subject = certificate.getSubjectX500Principal();
                X500Principal issuer = certificate.getIssuerX500Principal();
                sslSessionStatus = new SslSessionStatus(subject, issuer);
            }
        }
        catch (SSLPeerUnverifiedException peerUnverifiedException) {
            logger.debug("Peer Unverified", (Throwable)peerUnverifiedException);
        }
        return sslSessionStatus;
    }
}

