/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.nifi.event.transport.netty.channel.StandardChannelInitializer;

public class ClientSslStandardChannelInitializer<T extends Channel>
extends StandardChannelInitializer<T> {
    private final SSLContext sslContext;

    public ClientSslStandardChannelInitializer(Supplier<List<ChannelHandler>> handlerSupplier, SSLContext sslContext) {
        super(handlerSupplier);
        this.sslContext = Objects.requireNonNull(sslContext, "SSLContext is required");
    }

    @Override
    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.newSslHandler()});
        super.initChannel(channel);
    }

    private SslHandler newSslHandler() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return new SslHandler(sslEngine);
    }
}

