/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.enrich;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.whois.WhoisClient;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.enrich.AbstractEnrichProcessor;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"whois", "enrich", "ip"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="A powerful whois query processor primary designed to enrich DataFlows with whois based APIs (e.g. ShadowServer's ASN lookup) but that can be also used to perform regular whois lookups.")
@WritesAttributes(value={@WritesAttribute(attribute="enrich.dns.record*.group*", description="The captured fields of the Whois query response for each of the records received")})
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class QueryWhois
extends AbstractEnrichProcessor {
    public static final AllowableValue BEGIN_END = new AllowableValue("Begin/End", "Begin/End", "The evaluated input of each flowfile is enclosed within begin and end tags. Each row contains a delimited set of fields");
    public static final AllowableValue BULK_NONE = new AllowableValue("None", "None", "Queries are made without any particular dialect");
    public static final PropertyDescriptor WHOIS_QUERY_TYPE = new PropertyDescriptor.Builder().name("WHOIS_QUERY_TYPE").displayName("Whois Query Type").description("The Whois query type to be used by the processor (if used)").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor WHOIS_SERVER = new PropertyDescriptor.Builder().name("WHOIS_SERVER").displayName("Whois Server").description("The Whois server to be used").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor WHOIS_SERVER_PORT = new PropertyDescriptor.Builder().name("WHOIS_SERVER_PORT").displayName("Whois Server Port").description("The TCP port of the remote Whois server").required(true).defaultValue("43").addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor WHOIS_TIMEOUT = new PropertyDescriptor.Builder().name("WHOIS_TIMEOUT").displayName("Whois Query Timeout").description("The amount of time to wait until considering a query as failed").required(true).defaultValue("1500 ms").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("BATCH_SIZE").displayName("Batch Size").description("The number of incoming FlowFiles to process in a single execution of this processor. ").required(true).defaultValue("25").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor BULK_PROTOCOL = new PropertyDescriptor.Builder().name("BULK_PROTOCOL").displayName("Bulk Protocol").description("The protocol used to perform the bulk query. ").required(true).defaultValue(BULK_NONE.getValue()).allowableValues(new AllowableValue[]{BEGIN_END, BULK_NONE}).build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;
    private WhoisClient whoisClient;

    @Override
    public List<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String chosenQUERY_PARSER = validationContext.getProperty(QUERY_PARSER).getValue();
        if (!chosenQUERY_PARSER.equals(NONE.getValue()) && !validationContext.getProperty(QUERY_PARSER_INPUT).isSet()) {
            results.add(new ValidationResult.Builder().input("QUERY_PARSER_INPUT").subject(QUERY_PARSER_INPUT.getDisplayName()).explanation("Split and Regex parsers require a valid Regular Expression").valid(false).build());
        }
        if (validationContext.getProperty(BATCH_SIZE).asInteger() > 1 && !validationContext.getProperty(KEY_GROUP).isSet()) {
            results.add(new ValidationResult.Builder().input("KEY_GROUP").subject(KEY_GROUP.getDisplayName()).explanation("when operating in Batching mode, RegEx and Split parsers require a valid capture group/matching column. Configure the processor batch size to 1 or enter a valid column / named capture value.").valid(false).build());
        }
        if (validationContext.getProperty(BATCH_SIZE).asInteger() > 1 && chosenQUERY_PARSER.equals(NONE.getValue())) {
            results.add(new ValidationResult.Builder().input(validationContext.getProperty(BATCH_SIZE).getValue()).subject(QUERY_PARSER.getDisplayName()).explanation("NONE parser does not support batching. Configure Batch Size to 1 or use another parser.").valid(false).build());
        }
        if (validationContext.getProperty(BATCH_SIZE).asInteger() == 1 && !validationContext.getProperty(BULK_PROTOCOL).getValue().equals(BULK_NONE.getValue())) {
            results.add(new ValidationResult.Builder().input("BULK_PROTOCOL").subject(BATCH_SIZE.getDisplayName()).explanation("Bulk protocol requirement requires batching. Configure Batch Size to more than 1 or use another protocol.").valid(false).build());
        }
        return results;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        List flowFiles = session.get(batchSize);
        if (flowFiles == null || flowFiles.isEmpty()) {
            context.yield();
            return;
        }
        Object buildString = "";
        String queryType = context.getProperty(WHOIS_QUERY_TYPE).getValue();
        buildString = context.getProperty(BULK_PROTOCOL).getValue().equals(BEGIN_END.getValue()) ? ((String)buildString).concat("begin ") : ((String)buildString).concat("");
        buildString = context.getProperty(WHOIS_QUERY_TYPE).isSet() ? ((String)buildString).concat(queryType + " ") : ((String)buildString).concat("");
        buildString = context.getProperty(BULK_PROTOCOL).getValue().equals(BEGIN_END.getValue()) ? ((String)buildString).concat("\n") : ((String)buildString).concat("");
        for (FlowFile flowFile : flowFiles) {
            String evaluatedInput = context.getProperty(QUERY_INPUT).evaluateAttributeExpressions(flowFile).getValue();
            buildString = (String)buildString + evaluatedInput + "\n";
        }
        buildString = context.getProperty(BULK_PROTOCOL).getValue().equals(BEGIN_END.getValue()) ? ((String)buildString).concat("end") : ((String)buildString).concat("");
        String queryParser = context.getProperty(QUERY_PARSER).getValue();
        String queryRegex = context.getProperty(QUERY_PARSER_INPUT).getValue();
        int keyLookup = context.getProperty(KEY_GROUP).asInteger();
        int whoisTimeout = context.getProperty(WHOIS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        String whoisServer = context.getProperty(WHOIS_SERVER).getValue();
        int whoisPort = context.getProperty(WHOIS_SERVER_PORT).asInteger();
        ArrayList<FlowFile> flowFilesMatched = new ArrayList<FlowFile>();
        ArrayList<FlowFile> flowFilesNotMatched = new ArrayList<FlowFile>();
        String result = this.doLookup(whoisServer, whoisPort, whoisTimeout, (String)buildString);
        if (StringUtils.isEmpty((CharSequence)result)) {
            session.transfer((Collection)flowFiles, REL_NOT_FOUND);
            return;
        }
        for (FlowFile flowFile : flowFiles) {
            String ffLookupValue;
            if (batchSize == 1) {
                Map<String, String> parsedResults = this.parseResponse(null, result, queryParser, queryRegex, "whois");
                if (parsedResults.isEmpty()) {
                    flowFilesNotMatched.add(flowFile);
                    continue;
                }
                flowFile = session.putAllAttributes(flowFile, parsedResults);
                flowFilesMatched.add(flowFile);
                continue;
            }
            Map<String, Map<String, String>> rowMap = this.parseBatchResponse(result, queryParser, queryRegex, keyLookup, "whois");
            if (rowMap.containsKey(ffLookupValue = context.getProperty(QUERY_INPUT).evaluateAttributeExpressions(flowFile).getValue())) {
                flowFile = session.putAllAttributes(flowFile, rowMap.get(ffLookupValue));
                flowFilesMatched.add(flowFile);
                continue;
            }
            flowFilesNotMatched.add(flowFile);
        }
        if (flowFilesMatched.size() > 0) {
            session.transfer(flowFilesMatched, REL_FOUND);
        }
        if (flowFilesNotMatched.size() > 0) {
            session.transfer(flowFilesNotMatched, REL_NOT_FOUND);
        }
    }

    protected String doLookup(String whoisServer, int whoisPort, int whoisTimeout, String query) {
        String result = null;
        this.whoisClient = this.createClient();
        try {
            if (!this.whoisClient.isConnected()) {
                this.whoisClient.connect(whoisServer, whoisPort);
                this.whoisClient.setSoTimeout(whoisTimeout);
                result = this.whoisClient.query(query);
                if (this.whoisClient.isConnected()) {
                    this.whoisClient.disconnect();
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Query failed due to {}", new Object[]{e.getMessage(), e});
            throw new ProcessException("Error performing Whois Lookup", (Throwable)e);
        }
        return result;
    }

    protected WhoisClient createClient() {
        return new WhoisClient();
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(QUERY_INPUT);
        props.add(WHOIS_QUERY_TYPE);
        props.add(WHOIS_SERVER);
        props.add(WHOIS_SERVER_PORT);
        props.add(WHOIS_TIMEOUT);
        props.add(BATCH_SIZE);
        props.add(BULK_PROTOCOL);
        props.add(QUERY_PARSER);
        props.add(QUERY_PARSER_INPUT);
        props.add(KEY_GROUP);
        propertyDescriptors = Collections.unmodifiableList(props);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_FOUND);
        rels.add(REL_NOT_FOUND);
        relationships = Collections.unmodifiableSet(rels);
    }
}

