/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.AbstractEnrichIP;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"geo", "enrich", "ip", "maxmind"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Looks up geolocation information for an IP address and adds the geo information to FlowFile attributes. The geo data is provided as a MaxMind database. The attribute that contains the IP address to lookup is provided by the 'IP Address Attribute' property. If the name of the attribute provided is 'X', then the the attributes added by enrichment will take the form X.geo.<fieldName>")
@WritesAttributes(value={@WritesAttribute(attribute="X.geo.lookup.micros", description="The number of microseconds that the geo lookup took"), @WritesAttribute(attribute="X.geo.city", description="The city identified for the IP address"), @WritesAttribute(attribute="X.geo.accuracy", description="The accuracy radius if provided by the database (in Kilometers)"), @WritesAttribute(attribute="X.geo.latitude", description="The latitude identified for this IP address"), @WritesAttribute(attribute="X.geo.longitude", description="The longitude identified for this IP address"), @WritesAttribute(attribute="X.geo.subdivision.N", description="Each subdivision that is identified for this IP address is added with a one-up number appended to the attribute name, starting with 0"), @WritesAttribute(attribute="X.geo.subdivision.isocode.N", description="The ISO code for the subdivision that is identified by X.geo.subdivision.N"), @WritesAttribute(attribute="X.geo.country", description="The country identified for this IP address"), @WritesAttribute(attribute="X.geo.country.isocode", description="The ISO Code for the country identified"), @WritesAttribute(attribute="X.geo.postalcode", description="The postal code for the country identified")})
public class GeoEnrichIP
extends AbstractEnrichIP {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Integer accuracy;
        Double longitude;
        FlowFile flowFile;
        block32: {
            flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            try {
                if (!this.isNeedsReload() && !this.getWatcher().checkAndReset()) break block32;
                Lock dbWriteLock = this.getDbWriteLock();
                dbWriteLock.lock();
                try {
                    this.loadDatabaseFile();
                    this.setNeedsReload(false);
                }
                catch (InvalidDatabaseException | InternalError ie) {
                    this.setNeedsReload(true);
                    session.rollback();
                    return;
                }
                finally {
                    dbWriteLock.unlock();
                }
            }
            catch (IOException | IllegalStateException e) {
                throw new ProcessException(e.getMessage(), (Throwable)e);
            }
        }
        DatabaseReader dbReader = (DatabaseReader)this.databaseReaderRef.get();
        AbstractEnrichIP.MessageLogLevel logLevel = AbstractEnrichIP.MessageLogLevel.valueOf(context.getProperty(LOG_LEVEL).evaluateAttributeExpressions(flowFile).getValue().toUpperCase());
        String ipAttributeName = context.getProperty(IP_ADDRESS_ATTRIBUTE).evaluateAttributeExpressions(flowFile).getValue();
        String ipAttributeValue = flowFile.getAttribute(ipAttributeName);
        if (StringUtils.isEmpty((CharSequence)ipAttributeName)) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("FlowFile '{}' attribute '{}' was empty. Routing to failure", new Object[]{flowFile, IP_ADDRESS_ATTRIBUTE.getDisplayName()});
            return;
        }
        InetAddress inetAddress = null;
        CityResponse response = null;
        try {
            inetAddress = InetAddress.getByName(ipAttributeValue);
        }
        catch (IOException ioe) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("Could not resolve the IP for value '{}', contained within the attribute '{}' in FlowFile '{}'. This is usually caused by issue resolving the appropriate DNS record or providing the processor with an invalid IP address ", new Object[]{ipAttributeValue, IP_ADDRESS_ATTRIBUTE.getDisplayName(), flowFile, ioe});
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        try {
            this.getDbReadLock().lock();
            response = dbReader.city(inetAddress);
        }
        catch (InternalError ie) {
            this.setNeedsReload(true);
            session.rollback();
            return;
        }
        catch (InvalidDatabaseException idbe) {
            this.getLogger().warn("Failure while trying to load enrichment data for {} due to {}, rolling back session and will reload the database on the next run", new Object[]{flowFile, idbe.getMessage()});
            session.rollback();
            return;
        }
        catch (AddressNotFoundException anfe) {
            session.transfer(flowFile, REL_NOT_FOUND);
            switch (logLevel) {
                case INFO: {
                    this.getLogger().info("Address not found in the database", (Throwable)anfe);
                    return;
                }
                case WARN: {
                    this.getLogger().warn("Address not found in the database", (Throwable)anfe);
                    return;
                }
                case ERROR: {
                    this.getLogger().error("Address not found in the database", (Throwable)anfe);
                    return;
                }
                default: {
                    this.getLogger().debug("Address not found in the database", (Throwable)anfe);
                    return;
                }
            }
        }
        catch (GeoIp2Exception | IOException ex) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("Failure while trying to find enrichment data for {} due to {}", new Object[]{flowFile, ex, ex});
            return;
        }
        finally {
            stopWatch.stop();
            this.getDbReadLock().unlock();
        }
        if (response == null) {
            session.transfer(flowFile, REL_NOT_FOUND);
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ipAttributeName + ".geo.lookup.micros", String.valueOf(stopWatch.getDuration(TimeUnit.MICROSECONDS)));
        attrs.put(ipAttributeName + ".geo.city", response.getCity().getName());
        Double latitude = response.getLocation().getLatitude();
        if (latitude != null) {
            attrs.put(ipAttributeName + ".geo.latitude", latitude.toString());
        }
        if ((longitude = response.getLocation().getLongitude()) != null) {
            attrs.put(ipAttributeName + ".geo.longitude", longitude.toString());
        }
        if ((accuracy = response.getLocation().getAccuracyRadius()) != null) {
            attrs.put(ipAttributeName + ".accuracy", String.valueOf(accuracy));
        }
        int i = 0;
        for (Subdivision subd : response.getSubdivisions()) {
            attrs.put(ipAttributeName + ".geo.subdivision." + i, subd.getName());
            attrs.put(ipAttributeName + ".geo.subdivision.isocode." + i, subd.getIsoCode());
            ++i;
        }
        attrs.put(ipAttributeName + ".geo.country", response.getCountry().getName());
        attrs.put(ipAttributeName + ".geo.country.isocode", response.getCountry().getIsoCode());
        attrs.put(ipAttributeName + ".geo.postalcode", response.getPostal().getCode());
        flowFile = session.putAllAttributes(flowFile, attrs);
        session.transfer(flowFile, REL_FOUND);
    }
}

