/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.api.QueryDefinitionType;
import org.apache.nifi.util.StringUtils;

public interface ElasticsearchRestProcessor
extends Processor,
VerifiableProcessor {
    public static final String ATTR_RECORD_COUNT = "record.count";
    public static final String VERIFICATION_STEP_INDEX_EXISTS = "Elasticsearch Index Exists";
    public static final String VERIFICATION_STEP_QUERY_JSON_VALID = "Elasticsearch Query JSON Valid";
    public static final String VERIFICATION_STEP_QUERY_VALID = "Elasticsearch Query Valid";
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-rest-fetch-index").displayName("Index").description("The name of the index to use.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-rest-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching).").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor QUERY_DEFINITION_STYLE = new PropertyDescriptor.Builder().name("el-rest-query-definition-style").displayName("Query Definition Style").description("How the JSON Query will be defined for use by the processor.").required(true).allowableValues(QueryDefinitionType.class).defaultValue(QueryDefinitionType.FULL_QUERY.getValue()).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("el-rest-query").displayName("Query").description("A query in JSON syntax, not Lucene syntax. Ex: {\"query\":{\"match\":{\"somefield\":\"somevalue\"}}}. If this parameter is not set, the query will be read from the flowfile content. If the query (property and flowfile content) is empty, a default empty JSON Object will be used, which will result in a \"match_all\" query in Elasticsearch.").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.FULL_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor QUERY_CLAUSE = new PropertyDescriptor.Builder().name("el-rest-query-clause").displayName("Query Clause").description("A \"query\" clause in JSON syntax, not Lucene syntax. Ex: {\"match\":{\"somefield\":\"somevalue\"}}. If the query is empty, a default JSON Object will be used, which will result in a \"match_all\" query in Elasticsearch.").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SCRIPT = new PropertyDescriptor.Builder().name("el-rest-script").displayName("Script").description("A \"script\" to execute during the operation, in JSON syntax. Ex: {\"source\": \"ctx._source.count++\", \"lang\": \"painless\"}").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SIZE = new PropertyDescriptor.Builder().name("es-rest-size").displayName("Size").description("The maximum number of documents to retrieve in the query. If the query is paginated, this \"size\" applies to each page of the query, not the \"size\" of the entire result set.").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor AGGREGATIONS = new PropertyDescriptor.Builder().name("es-rest-query-aggs").displayName("Aggregations").description("One or more query aggregations (or \"aggs\"), in JSON syntax. Ex: {\"items\": {\"terms\": {\"field\": \"product\", \"size\": 10}}}").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SORT = new PropertyDescriptor.Builder().name("es-rest-query-sort").displayName("Sort").description("Sort results by one or more fields, in JSON syntax. Ex: [{\"price\" : {\"order\" : \"asc\", \"mode\" : \"avg\"}}, {\"post_date\" : {\"format\": \"strict_date_optional_time_nanos\"}}]").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor FIELDS = new PropertyDescriptor.Builder().name("es-rest-query-fields").displayName("Fields").description("Fields of indexed documents to be retrieved, in JSON syntax. Ex: [\"user.id\", \"http.response.*\", {\"field\": \"@timestamp\", \"format\": \"epoch_millis\"}]").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SCRIPT_FIELDS = new PropertyDescriptor.Builder().name("es-rest-query-script-fields").displayName("Script Fields").description("Fields to created using script evaluation at query runtime, in JSON syntax. Ex: {\"test1\": {\"script\": {\"lang\": \"painless\", \"source\": \"doc['price'].value * 2\"}}, \"test2\": {\"script\": {\"lang\": \"painless\", \"source\": \"doc['price'].value * params.factor\", \"params\": {\"factor\": 2.0}}}}").dependsOn(QUERY_DEFINITION_STYLE, (DescribedValue)QueryDefinitionType.BUILD_QUERY, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor QUERY_ATTRIBUTE = new PropertyDescriptor.Builder().name("el-query-attribute").displayName("Query Attribute").description("If set, the executed query will be set on each result flowfile in the specified attribute.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(Validator.VALID).required(false).build();
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An Elasticsearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();
    public static final PropertyDescriptor LOG_ERROR_RESPONSES = new PropertyDescriptor.Builder().name("put-es-record-log-error-responses").displayName("Log Error Responses").description("If this is enabled, errors will be logged to the NiFi logs at the error log level. Otherwise, they will only be logged if debug logging is enabled on NiFi as a whole. The purpose of this option is to give the user the ability to debug failed operations without having to turn on debug logging.").allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All flowfiles that fail for reasons unrelated to server availability go to this relationship.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("All flowfiles that fail due to server/cluster availability go to this relationship.").build();
    public static final String DEFAULT_QUERY_JSON = "{}";
    public static final ObjectMapper mapper = new ObjectMapper();

    default public String getQuery(FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        String retVal = this.getQuery(input != null ? input.getAttributes() : Collections.emptyMap(), context);
        if (DEFAULT_QUERY_JSON.equals(retVal) && input != null && QueryDefinitionType.FULL_QUERY.getValue().equals(context.getProperty(QUERY_DEFINITION_STYLE).getValue()) && !context.getProperty(QUERY).isSet()) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                session.exportTo(input, (OutputStream)out);
                retVal = out.toString();
            }
        }
        return StringUtils.isNotBlank((String)retVal) ? retVal : DEFAULT_QUERY_JSON;
    }

    default public String getQuery(Map<String, String> attributes, ProcessContext context) throws IOException {
        String retVal;
        if (QueryDefinitionType.FULL_QUERY.getValue().equals(context.getProperty(QUERY_DEFINITION_STYLE).getValue())) {
            retVal = context.getProperty(QUERY).isSet() ? context.getProperty(QUERY).evaluateAttributeExpressions(attributes).getValue() : null;
        } else {
            HashMap<String, Object> query = new HashMap<String, Object>(7, 1.0f);
            this.addQueryClause(query, attributes, context);
            if (context.getProperty(SIZE).isSet()) {
                query.put("size", context.getProperty(SIZE).evaluateAttributeExpressions(attributes).asInteger());
            }
            this.addSortClause(query, attributes, context);
            if (context.getProperty(AGGREGATIONS).isSet()) {
                query.put("aggs", mapper.readTree(context.getProperty(AGGREGATIONS).evaluateAttributeExpressions(attributes).getValue()));
            }
            if (context.getProperty(SCRIPT).isSet()) {
                query.put("script", mapper.readTree(context.getProperty(SCRIPT).evaluateAttributeExpressions(attributes).getValue()));
            }
            if (context.getProperty(FIELDS).isSet()) {
                query.put("fields", mapper.readTree(context.getProperty(FIELDS).evaluateAttributeExpressions(attributes).getValue()));
            }
            if (context.getProperty(SCRIPT_FIELDS).isSet()) {
                query.put("script_fields", mapper.readTree(context.getProperty(SCRIPT_FIELDS).evaluateAttributeExpressions(attributes).getValue()));
            }
            retVal = mapper.writeValueAsString(query);
        }
        return StringUtils.isNotBlank(retVal) ? retVal : DEFAULT_QUERY_JSON;
    }

    default public void addQueryClause(Map<String, Object> query, Map<String, String> attributes, ProcessContext context) throws IOException {
        if (context.getProperty(QUERY_CLAUSE).isSet()) {
            query.put("query", mapper.readTree(context.getProperty(QUERY_CLAUSE).evaluateAttributeExpressions(attributes).getValue()));
        }
    }

    default public void addSortClause(Map<String, Object> query, Map<String, String> attributes, ProcessContext context) throws IOException {
        if (context.getProperty(SORT).isSet()) {
            JsonNode sort = mapper.readTree(context.getProperty(SORT).evaluateAttributeExpressions(attributes).getValue());
            List<Map> sortList = sort.isArray() ? (List<Map>)mapper.convertValue((Object)sort, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}) : Collections.singletonList((Map)mapper.convertValue((Object)sort, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            query.put("sort", new ArrayList<Map>(sortList));
        }
    }

    default public Map<String, String> getDynamicProperties(ProcessContext context, FlowFile flowFile) {
        return this.getDynamicProperties(context, flowFile != null ? flowFile.getAttributes() : null);
    }

    default public Map<String, String> getDynamicProperties(ProcessContext context, Map<String, String> attributes) {
        return context.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic() && StringUtils.isNotBlank((String)((String)e.getValue())) && StringUtils.isNotBlank((String)context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions(attributes).getValue())).collect(Collectors.toMap(e -> ((PropertyDescriptor)e.getKey()).getName(), e -> context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions(attributes).getValue()));
    }

    default public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        boolean indexExists;
        String index;
        ElasticSearchClientService verifyClientService;
        ConfigVerificationResult.Builder indexExistsResult;
        ArrayList<ConfigVerificationResult> results;
        block9: {
            results = new ArrayList<ConfigVerificationResult>();
            indexExistsResult = new ConfigVerificationResult.Builder().verificationStepName(VERIFICATION_STEP_INDEX_EXISTS);
            verifyClientService = null;
            index = null;
            indexExists = false;
            if (context.getProperty(CLIENT_SERVICE).isSet()) {
                verifyClientService = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
                if (context.getProperty(INDEX).isSet()) {
                    index = context.getProperty(INDEX).evaluateAttributeExpressions(attributes).getValue();
                    try {
                        if (verifyClientService.exists(index, this.getDynamicProperties(context, attributes))) {
                            indexExistsResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Index [%s] exists", index));
                            indexExists = true;
                            break block9;
                        }
                        if (this.isIndexNotExistSuccessful()) {
                            indexExistsResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
                        } else {
                            indexExistsResult.outcome(ConfigVerificationResult.Outcome.FAILED);
                        }
                        indexExistsResult.explanation(String.format("Index [%s] does not exist", index));
                    }
                    catch (Exception ex) {
                        verificationLogger.error("Error checking whether index [{}] exists", new Object[]{index, ex});
                        indexExistsResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Failed to check whether index [%s] exists", index));
                    }
                } else {
                    indexExistsResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation(String.format("No [%s] specified for existence check", INDEX.getDisplayName()));
                }
            } else {
                indexExistsResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation(CLIENT_SERVICE.getDisplayName() + " not configured, cannot check index existence");
            }
        }
        results.add(indexExistsResult.build());
        results.addAll(this.verifyAfterIndex(context, verificationLogger, attributes, verifyClientService, index, indexExists));
        return results;
    }

    public boolean isIndexNotExistSuccessful();

    default public List<ConfigVerificationResult> verifyAfterIndex(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes, ElasticSearchClientService verifyClientService, String index, boolean indexExists) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        ConfigVerificationResult.Builder queryJsonValidResult = new ConfigVerificationResult.Builder().verificationStepName(VERIFICATION_STEP_QUERY_JSON_VALID);
        ConfigVerificationResult.Builder queryValidResult = new ConfigVerificationResult.Builder().verificationStepName(VERIFICATION_STEP_QUERY_VALID);
        if (indexExists) {
            try {
                String query = this.getQuery(attributes, context);
                verificationLogger.debug("Query JSON: {}", new Object[]{query});
                ObjectNode queryJson = (ObjectNode)mapper.readValue(query, ObjectNode.class);
                queryJsonValidResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Query JSON successfully parsed");
                if (queryJson.has("script")) {
                    verificationLogger.debug("Removing \"script\" field from verification Query, not valid for _search");
                    queryJson.remove("script");
                }
                String type = context.getProperty(TYPE).evaluateAttributeExpressions(attributes).getValue();
                HashMap<String, String> requestParameters = new HashMap<String, String>(this.getDynamicProperties(context, attributes));
                requestParameters.putIfAbsent("_source", "false");
                SearchResponse response = verifyClientService.search(mapper.writeValueAsString((Object)queryJson), index, type, requestParameters);
                queryValidResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Query found %d hits and %d aggregations in %d milliseconds, timed out: %s", response.getNumberOfHits(), response.getAggregations() == null ? 0 : response.getAggregations().size(), response.getTook(), response.isTimedOut()));
            }
            catch (IOException ioe) {
                verificationLogger.warn("Unable to parse Query as JSON", (Throwable)ioe);
                queryJsonValidResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Query cannot be parsed as valid JSON: %s", ioe.getMessage()));
                queryValidResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Query JSON could not be parsed");
            }
            catch (ElasticsearchException ee) {
                verificationLogger.warn("Query failed in Elasticsearch", (Throwable)ee);
                queryValidResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Query failed in Elasticsearch: %s", ee.getMessage()));
            }
        } else {
            String skippedReason = String.format("Index %s does not exist", index);
            queryJsonValidResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation(skippedReason);
            queryValidResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation(skippedReason);
        }
        results.add(queryJsonValidResult.build());
        results.add(queryValidResult.build());
        return results;
    }
}

