/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.OperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processors.elasticsearch.AbstractByQueryElasticsearch;

@WritesAttributes(value={@WritesAttribute(attribute="elasticsearch.delete.took", description="The amount of time that it took to complete the delete operation in ms."), @WritesAttribute(attribute="elasticsearch.delete.error", description="The error message provided by Elasticsearch if there is an error running the delete.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"elastic", "elasticsearch", "elasticsearch5", "elasticsearch6", "elasticsearch7", "elasticsearch8", "delete", "query"})
@CapabilityDescription(value="Delete from an Elasticsearch index using a query. The query can be loaded from a flowfile body or from the Query parameter.")
@DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the query request body")
public class DeleteByQueryElasticsearch
extends AbstractByQueryElasticsearch {
    static final String TOOK_ATTRIBUTE = "elasticsearch.delete.took";
    static final String ERROR_ATTRIBUTE = "elasticsearch.delete.error";
    private static final List<PropertyDescriptor> propertyDescriptors;

    @Override
    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @Override
    String getTookAttribute() {
        return TOOK_ATTRIBUTE;
    }

    @Override
    String getErrorAttribute() {
        return ERROR_ATTRIBUTE;
    }

    @Override
    OperationResponse performOperation(ElasticSearchClientService clientService, String query, String index, String type, Map<String, String> requestParameters) {
        return clientService.deleteByQuery(query, index, type, requestParameters);
    }

    static {
        ArrayList descriptors = new ArrayList(byQueryPropertyDescriptors.stream().filter(pd -> !SCRIPT.equals(pd)).collect(Collectors.toList()));
        propertyDescriptors = Collections.unmodifiableList(descriptors);
    }
}

