/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch.api;

import java.util.Arrays;
import org.apache.nifi.components.DescribedValue;

public enum PaginationType implements DescribedValue
{
    SCROLL("pagination-scroll", "Use Elasticsearch \"_scroll\" API to page results. Does not accept additional query parameters."),
    SEARCH_AFTER("pagination-search_after", "Use Elasticsearch \"search_after\" _search API to page sorted results."),
    POINT_IN_TIME("pagination-pit", "Use Elasticsearch (7.10+ with XPack) \"point in time\" _search API to page sorted results.");

    private final String value;
    private final String description;

    private PaginationType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public static PaginationType fromValue(String value) {
        return Arrays.stream(PaginationType.values()).filter(v -> v.getValue().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown value %s", value)));
    }
}

