/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.JsonInferenceSchemaRegistryService;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

@CapabilityDescription(value="Lookup a record from Elasticsearch Server associated with the specified document ID. The coordinates that are passed to the lookup must contain the key 'id'.")
@Tags(value={"lookup", "enrich", "record", "elasticsearch"})
@DynamicProperty(name="A JSONPath expression", value="A Record Path expression", description="Retrieves an object using JSONPath from the result document and places it in the return Record at the specified Record Path.")
public class ElasticSearchLookupService
extends JsonInferenceSchemaRegistryService
implements LookupService<Record> {
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An ElasticSearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-lookup-index").displayName("Index").description("The name of the index to read from").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-lookup-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching)").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private ElasticSearchClientService clientService;
    private String index;
    private String type;
    private ObjectMapper mapper;
    private volatile ConcurrentHashMap<String, RecordPath> recordPathMappings;
    private final List<PropertyDescriptor> descriptors;

    public ElasticSearchLookupService() {
        ArrayList<PropertyDescriptor> desc = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        desc.add(CLIENT_SERVICE);
        desc.add(INDEX);
        desc.add(TYPE);
        this.descriptors = Collections.unmodifiableList(desc);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.clientService = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
        this.index = context.getProperty(INDEX).evaluateAttributeExpressions().getValue();
        this.type = context.getProperty(TYPE).evaluateAttributeExpressions().getValue();
        this.mapper = new ObjectMapper();
        List dynamicDescriptors = context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toList());
        HashMap<String, RecordPath> tempRecordPathMappings = new HashMap<String, RecordPath>();
        for (PropertyDescriptor desc : dynamicDescriptors) {
            String value = context.getProperty(desc).getValue();
            String name = desc.getName();
            tempRecordPathMappings.put(name, RecordPath.compile((String)value));
        }
        this.recordPathMappings = new ConcurrentHashMap(tempRecordPathMappings);
        super.onEnabled(context);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    public PropertyDescriptor getSupportedDynamicPropertyDescriptor(String name) {
        return new PropertyDescriptor.Builder().name(name).addValidator((subject, input, context) -> {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            try {
                JsonPath.parse((String)input);
                builder.valid(true);
            }
            catch (Exception ex) {
                builder.explanation(ex.getMessage()).valid(false).subject(subject);
            }
            return builder.build();
        }).dynamic(true).build();
    }

    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        Map<String, String> context = coordinates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return this.lookup(coordinates, context);
    }

    public Optional<Record> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        this.validateCoordinates(coordinates);
        try {
            Record record = coordinates.containsKey("_id") ? this.getById((String)coordinates.get("_id"), context) : this.getByQuery(coordinates, context);
            return record == null ? Optional.empty() : Optional.of(record);
        }
        catch (Exception ex) {
            this.getLogger().error("Error during lookup.", (Throwable)ex);
            throw new LookupFailureException((Throwable)ex);
        }
    }

    private void validateCoordinates(Map<String, Object> coordinates) throws LookupFailureException {
        ArrayList<String> reasons = new ArrayList<String>();
        if (coordinates.containsKey("_id") && !(coordinates.get("_id") instanceof String)) {
            reasons.add("_id was supplied, but it was not a String.");
        }
        if (coordinates.containsKey("_id") && coordinates.size() > 1) {
            reasons.add("When _id is used, it can be the only key used in the lookup.");
        }
        if (!reasons.isEmpty()) {
            String error = String.join((CharSequence)"\n", reasons);
            throw new LookupFailureException(error);
        }
    }

    private Record getById(final String _id, Map<String, String> context) throws IOException, LookupFailureException, SchemaNotFoundException {
        HashMap<String, Object> query = new HashMap<String, Object>(){
            {
                this.put("query", new HashMap<String, Object>(){
                    {
                        this.put("match", new HashMap<String, String>(){
                            {
                                this.put("_id", _id);
                            }
                        });
                    }
                });
            }
        };
        String json = this.mapper.writeValueAsString((Object)query);
        SearchResponse response = this.clientService.search(json, this.index, this.type, null);
        if (response.getNumberOfHits() > 1L) {
            throw new LookupFailureException(String.format("Expected 1 response, got %d for query %s", response.getNumberOfHits(), json));
        }
        if (response.getNumberOfHits() == 0L) {
            return null;
        }
        Map source = (Map)((Map)response.getHits().get(0)).get("_source");
        RecordSchema toUse = this.getSchema(context, source, null);
        MapRecord record = new MapRecord(toUse, source);
        if (this.recordPathMappings.size() > 0) {
            record = this.applyMappings((Record)record, source);
        }
        return record;
    }

    Map<String, Object> getNested(final String key, final Object value) {
        final String path = key.substring(0, key.lastIndexOf("."));
        return new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("query", new HashMap<String, Object>(){
                    {
                        this.put("match", new HashMap<String, Object>(){
                            {
                                this.put(key, value);
                            }
                        });
                    }
                });
            }
        };
    }

    private Map<String, Object> buildQuery(final Map<String, Object> coordinates) {
        final HashMap<String, Object> query = new HashMap<String, Object>(){
            {
                this.put("bool", new HashMap<String, Object>(){
                    {
                        this.put("must", coordinates.entrySet().stream().map(e -> new HashMap<String, Object>(){
                            {
                                if (((String)e.getKey()).contains(".")) {
                                    this.put("nested", ElasticSearchLookupService.this.getNested((String)e.getKey(), e.getValue()));
                                } else {
                                    this.put("match", new HashMap<String, Object>(){
                                        {
                                            this.put((String)e.getKey(), e.getValue());
                                        }
                                    });
                                }
                            }
                        }).collect(Collectors.toList()));
                    }
                });
            }
        };
        return new HashMap<String, Object>(){
            {
                this.put("size", 1);
                this.put("query", query);
            }
        };
    }

    private Record getByQuery(Map<String, Object> query, Map<String, String> context) throws LookupFailureException {
        try {
            String json = this.mapper.writeValueAsString(this.buildQuery(query));
            SearchResponse response = this.clientService.search(json, this.index, this.type, null);
            if (response.getNumberOfHits() == 0L) {
                return null;
            }
            Map source = (Map)((Map)response.getHits().get(0)).get("_source");
            RecordSchema toUse = this.getSchema(context, source, null);
            MapRecord record = new MapRecord(toUse, source);
            if (this.recordPathMappings.size() > 0) {
                record = this.applyMappings((Record)record, source);
            }
            return record;
        }
        catch (Exception e) {
            throw new LookupFailureException((Throwable)e);
        }
    }

    private Record applyMappings(Record record, Map<String, Object> source) {
        MapRecord rec = new MapRecord(record.getSchema(), new HashMap());
        this.recordPathMappings.forEach((arg_0, arg_1) -> ElasticSearchLookupService.lambda$applyMappings$3(source, (Record)rec, arg_0, arg_1));
        return rec;
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return Collections.emptySet();
    }

    private static /* synthetic */ void lambda$applyMappings$3(Map source, Record rec, String key, RecordPath path) {
        try {
            Object o = JsonPath.read((Object)source, (String)key, (Predicate[])new Predicate[0]);
            Optional<FieldValue> first = path.evaluate(rec).getSelectedFields().findFirst();
            first.ifPresent(fieldValue -> fieldValue.updateValue(o));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

