/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.util.hive.CsvOutputOptions;

public class HiveJdbcCommon {
    public static final String AVRO = "Avro";
    public static final String CSV = "CSV";
    public static final String MIME_TYPE_AVRO_BINARY = "application/avro-binary";
    public static final String CSV_MIME_TYPE = "text/csv";
    private static final Schema TIMESTAMP_MILLIS_SCHEMA = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    private static final Schema DATE_SCHEMA = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
    private static final int DEFAULT_PRECISION = 10;
    private static final int DEFAULT_SCALE = 0;
    public static final PropertyDescriptor NORMALIZE_NAMES_FOR_AVRO = new PropertyDescriptor.Builder().name("hive-normalize-avro").displayName("Normalize Table/Column Names").description("Whether to change non-Avro-compatible characters in column names to Avro-compatible characters. For example, colons and periods will be changed to underscores in order to build a valid Avro record.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, int maxRows, boolean convertNames, boolean useLogicalTypes) throws SQLException, IOException {
        return HiveJdbcCommon.convertToAvroStream(rs, outStream, null, maxRows, convertNames, null, useLogicalTypes);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, int maxRows, boolean convertNames, ResultSetRowCallback callback, boolean useLogicalTypes) throws SQLException, IOException {
        Schema schema = HiveJdbcCommon.createSchema(rs, recordName, convertNames, useLogicalTypes);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                if (callback != null) {
                    callback.processRow(rs);
                }
                for (int i = 1; i <= nrOfColumns; ++i) {
                    int javaSqlType = meta.getColumnType(i);
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2004 || javaSqlType == 2005) {
                        ByteBuffer bb = null;
                        if (value instanceof byte[]) {
                            bb = ByteBuffer.wrap((byte[])value);
                        } else if (value instanceof ByteBuffer) {
                            bb = (ByteBuffer)value;
                        }
                        if (bb != null) {
                            rec.put(i - 1, (Object)bb);
                            continue;
                        }
                        throw new IOException("Could not process binary object of type " + value.getClass().getName());
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        if (useLogicalTypes) {
                            int precision = HiveJdbcCommon.getPrecision(meta.getPrecision(i));
                            int scale = HiveJdbcCommon.getScale(meta.getScale(i));
                            rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES))));
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof BigInteger) {
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number) {
                        if (javaSqlType == 6) {
                            value = Float.valueOf(rs.getFloat(i));
                        } else if (javaSqlType == 8) {
                            value = rs.getDouble(i);
                        } else if (javaSqlType == 4 || javaSqlType == -6 || javaSqlType == 5) {
                            value = rs.getInt(i);
                        }
                        rec.put(i - 1, value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        rec.put(i - 1, value);
                        continue;
                    }
                    if (value instanceof SQLXML) {
                        rec.put(i - 1, (Object)((SQLXML)value).getString());
                        continue;
                    }
                    if (useLogicalTypes && javaSqlType == 91) {
                        rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)DATE_SCHEMA));
                        continue;
                    }
                    if (useLogicalTypes && javaSqlType == 93) {
                        rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)TIMESTAMP_MILLIS_SCHEMA));
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                if (maxRows <= 0 || ++nrOfRows != (long)maxRows) continue;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs, boolean convertNames) throws SQLException {
        return HiveJdbcCommon.createSchema(rs, null, false, false);
    }

    public static Schema createSchema(ResultSet rs, String recordName, boolean convertNames, boolean useLogicalTypes) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String tableName = StringUtils.isEmpty((CharSequence)recordName) ? "NiFi_SelectHiveQL_Record" : recordName;
        try {
            String tableNameFromMeta;
            String firstColumnNameFromMeta;
            int tableNameDelimiter;
            if (nrOfColumns > 0 && (tableNameDelimiter = (firstColumnNameFromMeta = meta.getColumnName(1)).lastIndexOf(".")) > -1 && !StringUtils.isBlank((CharSequence)(tableNameFromMeta = firstColumnNameFromMeta.substring(0, tableNameDelimiter)))) {
                tableName = tableNameFromMeta;
            }
        }
        catch (SQLException firstColumnNameFromMeta) {
            // empty catch block
        }
        if (convertNames) {
            tableName = HiveJdbcCommon.normalizeNameForAvro(tableName);
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block18: for (int i = 1; i <= nrOfColumns; ++i) {
            String columnNameFromMeta = meta.getColumnName(i);
            int columnNameDelimiter = columnNameFromMeta.lastIndexOf(".");
            String columnName = columnNameFromMeta.substring(columnNameDelimiter + 1);
            if (convertNames) {
                columnName = HiveJdbcCommon.normalizeNameForAvro(columnName);
            }
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 1111: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2009: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block18;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block18;
                }
                case 4: {
                    boolean signedType = true;
                    try {
                        signedType = meta.isSigned(i);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (signedType) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                        continue block18;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block18;
                }
                case -6: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block18;
                }
                case -5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block18;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block18;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block18;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block18;
                }
                case 2: 
                case 3: {
                    if (useLogicalTypes) {
                        int precision = HiveJdbcCommon.getPrecision(meta.getPrecision(i));
                        int scale = HiveJdbcCommon.getScale(meta.getScale(i));
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().type(LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)))).endUnion()).noDefault();
                        continue block18;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block18;
                }
                case 91: {
                    if (useLogicalTypes) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().type(DATE_SCHEMA)).endUnion()).noDefault();
                        continue block18;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block18;
                }
                case 92: 
                case 93: {
                    if (useLogicalTypes) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().type(TIMESTAMP_MILLIS_SCHEMA)).endUnion()).noDefault();
                        continue block18;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block18;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }

    public static long convertToCsvStream(ResultSet rs, OutputStream outStream, CsvOutputOptions outputOptions) throws SQLException, IOException {
        return HiveJdbcCommon.convertToCsvStream(rs, outStream, null, null, outputOptions);
    }

    public static long convertToCsvStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, CsvOutputOptions outputOptions) throws SQLException, IOException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        List<Object> columnNames = new ArrayList(nrOfColumns);
        if (outputOptions.isHeader()) {
            if (outputOptions.getAltHeader() == null) {
                for (int i = 1; i <= nrOfColumns; ++i) {
                    String columnNameFromMeta = meta.getColumnName(i);
                    int columnNameDelimiter = columnNameFromMeta.lastIndexOf(".");
                    columnNames.add(columnNameFromMeta.substring(columnNameDelimiter + 1));
                }
            } else {
                String[] altHeaderNames = outputOptions.getAltHeader().split(",");
                columnNames = Arrays.asList(altHeaderNames);
            }
        }
        outStream.write(StringUtils.join(columnNames, (String)outputOptions.getDelimiter()).getBytes(StandardCharsets.UTF_8));
        if (outputOptions.isHeader()) {
            outStream.write("\n".getBytes(StandardCharsets.UTF_8));
        }
        int maxRows = outputOptions.getMaxRowsPerFlowFile();
        long nrOfRows = 0L;
        while (rs.next()) {
            if (callback != null) {
                callback.processRow(rs);
            }
            ArrayList<String> rowValues = new ArrayList<String>(nrOfColumns);
            block7: for (int i = 1; i <= nrOfColumns; ++i) {
                int javaSqlType = meta.getColumnType(i);
                Object value = rs.getObject(i);
                switch (javaSqlType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String valueString = rs.getString(i);
                        if (valueString != null) {
                            StringBuilder sb = new StringBuilder();
                            if (outputOptions.isQuote()) {
                                sb.append("\"");
                                if (outputOptions.isEscape()) {
                                    sb.append(StringEscapeUtils.escapeCsv((String)valueString));
                                } else {
                                    sb.append(valueString);
                                }
                                sb.append("\"");
                                rowValues.add(sb.toString());
                                continue block7;
                            }
                            if (outputOptions.isEscape()) {
                                rowValues.add(StringEscapeUtils.escapeCsv((String)valueString));
                                continue block7;
                            }
                            rowValues.add(valueString);
                            continue block7;
                        }
                        rowValues.add("");
                        continue block7;
                    }
                    case 2000: 
                    case 2002: 
                    case 2003: {
                        String complexValueString = rs.getString(i);
                        if (complexValueString != null) {
                            rowValues.add(StringEscapeUtils.escapeCsv((String)complexValueString));
                            continue block7;
                        }
                        rowValues.add("");
                        continue block7;
                    }
                    case 2009: {
                        if (value != null) {
                            rowValues.add(StringEscapeUtils.escapeCsv((String)((SQLXML)value).getString()));
                            continue block7;
                        }
                        rowValues.add("");
                        continue block7;
                    }
                    default: {
                        if (value != null) {
                            rowValues.add(value.toString());
                            continue block7;
                        }
                        rowValues.add("");
                    }
                }
            }
            outStream.write(StringUtils.join(rowValues, (String)outputOptions.getDelimiter()).getBytes(StandardCharsets.UTF_8));
            outStream.write("\n".getBytes(StandardCharsets.UTF_8));
            if (maxRows <= 0 || ++nrOfRows != (long)maxRows) continue;
            break;
        }
        return nrOfRows;
    }

    public static String normalizeNameForAvro(String inputName) {
        Object normalizedName = inputName.replaceAll("[^A-Za-z0-9_]", "_");
        if (Character.isDigit(((String)normalizedName).charAt(0))) {
            normalizedName = "_" + (String)normalizedName;
        }
        return normalizedName;
    }

    public static Configuration getConfigurationFromFiles(String configFiles) {
        HiveConf hiveConfig = new HiveConf();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                hiveConfig.addResource(new Path(configFile.trim()));
            }
        }
        return hiveConfig;
    }

    private static int getPrecision(int precision) {
        return precision > 1 ? precision : 10;
    }

    private static int getScale(int scale) {
        return scale > 0 ? scale : 0;
    }

    public static interface ResultSetRowCallback {
        public void processRow(ResultSet var1) throws IOException;
    }
}

