/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.dropbox.DropboxTrait;
import org.apache.nifi.processors.dropbox.ListDropbox;
import org.apache.nifi.processors.dropbox.PutDropbox;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"dropbox", "storage", "fetch"})
@CapabilityDescription(value="Fetches files from Dropbox. Designed to be used in tandem with ListDropbox.")
@SeeAlso(value={PutDropbox.class, ListDropbox.class})
@WritesAttributes(value={@WritesAttribute(attribute="error.message", description="The error message returned by Dropbox"), @WritesAttribute(attribute="dropbox.id", description="The Dropbox identifier of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="dropbox.size", description="The size of the file"), @WritesAttribute(attribute="dropbox.timestamp", description="The server modified time of the file"), @WritesAttribute(attribute="dropbox.revision", description="Revision of the file")})
public class FetchDropbox
extends AbstractProcessor
implements DropboxTrait {
    public static final PropertyDescriptor FILE = new PropertyDescriptor.Builder().name("file").displayName("File").description("The Dropbox identifier or path of the Dropbox file to fetch. The 'File' should match the following regular expression pattern: /.*|id:.* . When ListDropbox is used for input, either '${dropbox.id}' (identifying files by Dropbox id) or '${path}/${filename}' (identifying files by path) can be used as 'File' value.").required(true).defaultValue("${dropbox.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("/.*|id:.*"))).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here for each successfully fetched File.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here for each File for which fetch was attempted but failed.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_SERVICE, FILE, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])new ProxySpec[]{ProxySpec.HTTP_AUTH})));
    private volatile DbxClientV2 dropboxApiClient;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.dropboxApiClient = this.getDropboxApiClient(context, this.getIdentifier());
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileIdentifier = context.getProperty(FILE).evaluateAttributeExpressions(flowFile).getValue();
        fileIdentifier = this.correctFilePath(fileIdentifier);
        FlowFile outFlowFile = flowFile;
        long startNanos = System.nanoTime();
        try {
            FileMetadata fileMetadata = this.fetchFile(fileIdentifier, session, outFlowFile);
            Map attributes = this.createAttributeMap(fileMetadata);
            outFlowFile = session.putAllAttributes(outFlowFile, attributes);
            String url = "https://www.dropbox.com/home" + fileMetadata.getPathDisplay();
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, url, transferMillis);
            session.transfer(outFlowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.handleError(session, flowFile, fileIdentifier, e);
        }
    }

    private FileMetadata fetchFile(String fileId, ProcessSession session, FlowFile outFlowFile) throws DbxException {
        try (DbxDownloader downloader = this.dropboxApiClient.files().download(fileId);){
            InputStream dropboxInputStream = downloader.getInputStream();
            session.importFrom(dropboxInputStream, outFlowFile);
            FileMetadata fileMetadata = (FileMetadata)downloader.getResult();
            return fileMetadata;
        }
    }

    private void handleError(ProcessSession session, FlowFile flowFile, String fileId, Exception e) {
        this.getLogger().error("Error while fetching and processing file with id '{}'", new Object[]{fileId, e});
        FlowFile outFlowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        session.penalize(outFlowFile);
        session.transfer(outFlowFile, REL_FAILURE);
    }

    private String correctFilePath(String folderName) {
        return folderName.startsWith("//") ? folderName.replaceFirst("//", "/") : folderName;
    }
}

