/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.OkHttp3Requestor;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.v2.DbxClientV2;
import java.net.Proxy;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.dropbox.credentials.service.DropboxCredentialDetails;
import org.apache.nifi.dropbox.credentials.service.DropboxCredentialService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.proxy.ProxyConfiguration;

public interface DropboxTrait {
    public static final PropertyDescriptor CREDENTIAL_SERVICE = new PropertyDescriptor.Builder().name("dropbox-credential-service").displayName("Dropbox Credential Service").description("Controller Service used to obtain Dropbox credentials (App Key, App Secret, Access Token, Refresh Token). See controller service's Additional Details for more information.").identifiesControllerService(DropboxCredentialService.class).required(true).build();

    default public DbxClientV2 getDropboxApiClient(ProcessContext context, ProxyConfiguration proxyConfiguration, String clientId) {
        OkHttpClient.Builder okHttpClientBuilder = OkHttp3Requestor.defaultOkHttpClientBuilder();
        if (!Proxy.Type.DIRECT.equals((Object)proxyConfiguration.getProxyType())) {
            okHttpClientBuilder.proxy(proxyConfiguration.createProxy());
            if (proxyConfiguration.hasCredential()) {
                okHttpClientBuilder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)proxyConfiguration.getProxyUserName(), (String)proxyConfiguration.getProxyUserPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        OkHttp3Requestor httpRequestor = new OkHttp3Requestor(okHttpClientBuilder.build());
        DbxRequestConfig config = DbxRequestConfig.newBuilder((String)clientId).withHttpRequestor((HttpRequestor)httpRequestor).build();
        DropboxCredentialService credentialService = (DropboxCredentialService)context.getProperty(CREDENTIAL_SERVICE).asControllerService(DropboxCredentialService.class);
        DropboxCredentialDetails credential = credentialService.getDropboxCredential();
        return new DbxClientV2(config, new DbxCredential(credential.getAccessToken(), Long.valueOf(-1L), credential.getRefreshToken(), credential.getAppKey(), credential.getAppSecret()));
    }
}

