/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class DropboxFileInfo
implements ListableEntity {
    public static final String ID = "dropbox.id";
    public static final String PATH = "path";
    public static final String FILENAME = "filename";
    public static final String SIZE = "dropbox.size";
    public static final String TIMESTAMP = "dropbox.timestamp";
    public static final String REVISION = "dropbox.revision";
    private static final RecordSchema SCHEMA;
    private final String id;
    private final String path;
    private final String filename;
    private final long size;
    private final long timestamp;
    private final String revision;

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    private DropboxFileInfo(Builder builder) {
        this.id = builder.id;
        this.path = builder.path;
        this.filename = builder.filename;
        this.size = builder.size;
        this.timestamp = builder.timestamp;
        this.revision = builder.revision;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getFileName() {
        return this.filename;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(ID, this.getId());
        values.put(PATH, this.getPath());
        values.put(FILENAME, this.getFileName());
        values.put(SIZE, this.getSize());
        values.put(TIMESTAMP, this.getTimestamp());
        values.put(REVISION, this.getRevision());
        return new MapRecord(SCHEMA, values);
    }

    public String getName() {
        return this.getFileName();
    }

    public String getIdentifier() {
        return this.getId();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropboxFileInfo that = (DropboxFileInfo)o;
        return this.id.equals(that.id) && this.size == that.size && this.timestamp == that.timestamp && this.path.equals(that.path) && this.filename.equals(that.filename) && this.revision.equals(that.revision);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.filename, this.size, this.timestamp, this.revision);
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(ID, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(PATH, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(TIMESTAMP, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(REVISION, RecordFieldType.STRING.getDataType(), false));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private String id;
        private String path;
        private String filename;
        private long size;
        private long timestamp;
        private String revision;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder name(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder timestamp(long createdTime) {
            this.timestamp = createdTime;
            return this;
        }

        public Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public DropboxFileInfo build() {
            return new DropboxFileInfo(this);
        }
    }
}

