/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class CacheRecord {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long id;
    private final long entryDate;
    private volatile long lastHitDate;
    private final AtomicInteger hitCount = new AtomicInteger(0);

    public CacheRecord() {
        this.lastHitDate = this.entryDate = System.currentTimeMillis();
        this.id = idGenerator.getAndIncrement();
    }

    public long getEntryDate() {
        return this.entryDate;
    }

    public long getLastHitDate() {
        return this.lastHitDate;
    }

    public int getHitCount() {
        return this.hitCount.get();
    }

    public void hit() {
        this.hitCount.getAndIncrement();
        this.lastHitDate = System.currentTimeMillis();
    }

    public long getId() {
        return this.id;
    }
}

