/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.distributed.cache.server.CacheRecord;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapCacheRecord;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMapCache
implements MapCache {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMapCache.class);
    private final Map<ByteBuffer, MapCacheRecord> cache = new HashMap<ByteBuffer, MapCacheRecord>();
    private final SortedMap<MapCacheRecord, ByteBuffer> inverseCacheMap;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final String serviceIdentifier;
    private final int maxSize;

    public SimpleMapCache(String serviceIdentifier, int maxSize, EvictionPolicy evictionPolicy) {
        this.inverseCacheMap = new ConcurrentSkipListMap<CacheRecord, ByteBuffer>(evictionPolicy.getComparator());
        this.serviceIdentifier = serviceIdentifier;
        this.maxSize = maxSize;
    }

    public String toString() {
        return "SimpleMapCache[service id=" + this.serviceIdentifier + "]";
    }

    private MapCacheRecord evict() {
        if (this.cache.size() < this.maxSize) {
            return null;
        }
        MapCacheRecord recordToEvict = this.inverseCacheMap.firstKey();
        ByteBuffer valueToEvict = (ByteBuffer)this.inverseCacheMap.remove(recordToEvict);
        this.cache.remove(valueToEvict);
        if (logger.isDebugEnabled()) {
            logger.debug("Evicting value {} from cache", (Object)new String(valueToEvict.array(), StandardCharsets.UTF_8));
        }
        return recordToEvict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapPutResult putIfAbsent(ByteBuffer key, ByteBuffer value) {
        this.writeLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                MapPutResult mapPutResult = this.put(key, value, record);
                return mapPutResult;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            MapPutResult mapPutResult = new MapPutResult(false, record, record, null);
            return mapPutResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private MapPutResult put(ByteBuffer key, ByteBuffer value, MapCacheRecord existing) {
        long revision;
        MapCacheRecord evicted = this.evict();
        if (existing == null) {
            revision = 0L;
        } else {
            revision = existing.getRevision() + 1L;
            this.inverseCacheMap.remove(existing);
        }
        MapCacheRecord record = new MapCacheRecord(key, value, revision);
        this.cache.put(key, record);
        this.inverseCacheMap.put(record, key);
        return new MapPutResult(true, record, existing, evicted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapPutResult put(ByteBuffer key, ByteBuffer value) throws IOException {
        this.writeLock.lock();
        try {
            MapCacheRecord existing = this.cache.get(key);
            MapPutResult mapPutResult = this.put(key, value, existing);
            return mapPutResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(ByteBuffer key) {
        this.readLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                boolean bl = false;
                return bl;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer get(ByteBuffer key) {
        this.readLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            ByteBuffer byteBuffer = record.getValue();
            return byteBuffer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<ByteBuffer, ByteBuffer> subMap(List<ByteBuffer> keys) throws IOException {
        if (keys == null) {
            return null;
        }
        HashMap<ByteBuffer, ByteBuffer> results = new HashMap<ByteBuffer, ByteBuffer>(keys.size());
        this.readLock.lock();
        try {
            keys.forEach(key -> {
                MapCacheRecord record = this.cache.get(key);
                if (record == null) {
                    results.put((ByteBuffer)key, (ByteBuffer)null);
                } else {
                    this.inverseCacheMap.remove(record);
                    record.hit();
                    this.inverseCacheMap.put(record, (ByteBuffer)key);
                    results.put((ByteBuffer)key, record.getValue());
                }
            });
        }
        finally {
            this.readLock.unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer remove(ByteBuffer key) throws IOException {
        this.writeLock.lock();
        try {
            MapCacheRecord record = this.cache.remove(key);
            if (record == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            this.inverseCacheMap.remove(record);
            ByteBuffer byteBuffer = record.getValue();
            return byteBuffer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ByteBuffer, ByteBuffer> removeByPattern(String regex) throws IOException {
        this.writeLock.lock();
        try {
            HashMap removedMap = new HashMap();
            ArrayList<MapCacheRecord> removedRecords = new ArrayList<MapCacheRecord>();
            Pattern p = Pattern.compile(regex);
            for (ByteBuffer key : this.cache.keySet()) {
                Matcher m = p.matcher(new String(key.array()));
                if (!m.matches()) continue;
                removedRecords.add(this.cache.get(key));
            }
            removedRecords.forEach(record -> {
                this.cache.remove(record.getKey());
                this.inverseCacheMap.remove(record);
                removedMap.put(record.getKey(), record.getValue());
            });
            HashMap hashMap = removedMap;
            return hashMap;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapCacheRecord fetch(ByteBuffer key) throws IOException {
        this.readLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                MapCacheRecord mapCacheRecord = null;
                return mapCacheRecord;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            MapCacheRecord mapCacheRecord = record;
            return mapCacheRecord;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapPutResult replace(MapCacheRecord inputRecord) throws IOException {
        this.writeLock.lock();
        try {
            ByteBuffer key = inputRecord.getKey();
            ByteBuffer value = inputRecord.getValue();
            MapCacheRecord existing = this.fetch(key);
            if (existing != null && inputRecord.getRevision() != existing.getRevision()) {
                MapPutResult mapPutResult = new MapPutResult(false, inputRecord, existing, null);
                return mapPutResult;
            }
            MapPutResult mapPutResult = this.put(key, value, existing);
            return mapPutResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<ByteBuffer> keySet() throws IOException {
        this.readLock.lock();
        try {
            Set<ByteBuffer> set = this.cache.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void shutdown() throws IOException {
    }
}

