/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.File;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.server.CacheServer;
import org.apache.nifi.distributed.cache.server.DistributedCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.map.StandardMapCacheServer;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"distributed", "cluster", "map", "cache", "server", "key/value"})
@CapabilityDescription(value="Provides a map (key/value) cache that can be accessed over a socket. Interaction with this service is typically accomplished via a DistributedMapCacheClient service.")
@SeeAlso(classNames={"org.apache.nifi.distributed.cache.client.DistributedMapCacheClientService", "org.apache.nifi.ssl.StandardSSLContextService"})
public class DistributedMapCacheServer
extends DistributedCacheServer {
    @Override
    protected CacheServer createCacheServer(ConfigurationContext context) {
        EvictionPolicy evictionPolicy;
        int port = context.getProperty(PORT).asInteger();
        String persistencePath = context.getProperty(PERSISTENCE_PATH).getValue();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        int maxSize = context.getProperty(MAX_CACHE_ENTRIES).asInteger();
        String evictionPolicyName = context.getProperty(EVICTION_POLICY).getValue();
        int maxReadSize = context.getProperty(MAX_READ_SIZE).asDataSize(DataUnit.B).intValue();
        SSLContext sslContext = sslContextService == null ? null : sslContextService.createContext();
        switch (evictionPolicyName) {
            case "First In, First Out": {
                evictionPolicy = EvictionPolicy.FIFO;
                break;
            }
            case "Least Frequently Used": {
                evictionPolicy = EvictionPolicy.LFU;
                break;
            }
            case "Least Recently Used": {
                evictionPolicy = EvictionPolicy.LRU;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Eviction Policy: " + evictionPolicyName);
            }
        }
        try {
            File persistenceDir = persistencePath == null ? null : new File(persistencePath);
            return this.createMapCacheServer(port, maxSize, sslContext, evictionPolicy, persistenceDir, maxReadSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CacheServer createMapCacheServer(int port, int maxSize, SSLContext sslContext, EvictionPolicy evictionPolicy, File persistenceDir, int maxReadSize) throws IOException {
        return new StandardMapCacheServer(this.getLogger(), this.getIdentifier(), sslContext, port, maxSize, evictionPolicy, persistenceDir, maxReadSize);
    }
}

