/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.util.Collections;
import java.util.Set;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class ConnectionUrlValidator
implements Validator {
    private static final Set<String> UNSUPPORTED_SCHEMES = Collections.singleton("jdbc:h2");

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ValidationResult.Builder builder = new ValidationResult.Builder().subject(subject).input(input);
        if (input == null || input.isEmpty()) {
            builder.valid(false);
            builder.explanation("Connection URL required");
        } else {
            String url = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            if (this.isUrlUnsupported(url)) {
                builder.valid(false);
                builder.explanation(String.format("Connection URL starts with an unsupported scheme %s", UNSUPPORTED_SCHEMES));
            } else {
                builder.valid(true);
                builder.explanation("Connection URL is valid");
            }
        }
        return builder.build();
    }

    private boolean isUrlUnsupported(String url) {
        boolean unsupported = false;
        for (String unsupportedScheme : UNSUPPORTED_SCHEMES) {
            if (!url.startsWith(unsupportedScheme)) continue;
            unsupported = true;
            break;
        }
        return unsupported;
    }
}

