/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp.utils;

import org.apache.nifi.dbcp.utils.DefaultDataSourceValues;

public class DataSourceConfiguration {
    private final String url;
    private final String driverName;
    private final String userName;
    private final String password;
    private final long maxWaitMillis;
    private final int maxTotal;
    private final int minIdle;
    private final int maxIdle;
    private final long maxConnLifetimeMillis;
    private final long timeBetweenEvictionRunsMillis;
    private final long minEvictableIdleTimeMillis;
    private final long softMinEvictableIdleTimeMillis;
    private final String validationQuery;

    public String getUrl() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public DataSourceConfiguration(Builder builder) {
        this.url = builder.url;
        this.driverName = builder.driverName;
        this.userName = builder.userName;
        this.password = builder.password;
        this.maxWaitMillis = builder.maxWaitMillis;
        this.maxTotal = builder.maxTotal;
        this.minIdle = builder.minIdle;
        this.maxIdle = builder.maxIdle;
        this.maxConnLifetimeMillis = builder.maxConnLifetimeMillis;
        this.timeBetweenEvictionRunsMillis = builder.timeBetweenEvictionRunsMillis;
        this.minEvictableIdleTimeMillis = builder.minEvictableIdleTimeMillis;
        this.softMinEvictableIdleTimeMillis = builder.softMinEvictableIdleTimeMillis;
        this.validationQuery = builder.validationQuery;
    }

    public static class Builder {
        private final String url;
        private final String driverName;
        private final String userName;
        private final String password;
        private long maxWaitMillis = DefaultDataSourceValues.MAX_WAIT_TIME.getLongValue();
        private int maxTotal = DefaultDataSourceValues.MAX_TOTAL_CONNECTIONS.getLongValue().intValue();
        private int minIdle = DefaultDataSourceValues.MIN_IDLE.getLongValue().intValue();
        private int maxIdle = DefaultDataSourceValues.MAX_IDLE.getLongValue().intValue();
        private long maxConnLifetimeMillis = DefaultDataSourceValues.MAX_CONN_LIFETIME.getLongValue();
        private long timeBetweenEvictionRunsMillis = DefaultDataSourceValues.EVICTION_RUN_PERIOD.getLongValue();
        private long minEvictableIdleTimeMillis = DefaultDataSourceValues.MIN_EVICTABLE_IDLE_TIME.getLongValue();
        private long softMinEvictableIdleTimeMillis = DefaultDataSourceValues.SOFT_MIN_EVICTABLE_IDLE_TIME.getLongValue();
        private String validationQuery;

        public Builder(String url, String driverName, String userName, String password) {
            this.url = url;
            this.driverName = driverName;
            this.userName = userName;
            this.password = password;
        }

        public Builder maxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
            return this;
        }

        public Builder maxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder minIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public Builder maxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public Builder maxConnLifetimeMillis(long maxConnLifetimeMillis) {
            this.maxConnLifetimeMillis = maxConnLifetimeMillis;
            return this;
        }

        public Builder timeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public Builder minEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public Builder softMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
            this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
            return this;
        }

        public Builder validationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }
    }
}

