/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.datadog.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;

public class MetricsService {
    public Map<String, Double> getProcessorMetrics(ProcessorStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("FlowFilesReceivedLast5Minutes", Double.valueOf(status.getInputCount()));
        metrics.put("FlowFilesSentLast5Minutes", Double.valueOf(status.getOutputCount()));
        metrics.put("BytesReadLast5Minutes", Double.valueOf(status.getInputBytes()));
        metrics.put("BytesWrittenLast5Minutes", Double.valueOf(status.getOutputBytes()));
        metrics.put("ActiveThreads", Double.valueOf(status.getActiveThreadCount()));
        metrics.put("TotalTaskDurationSeconds", Double.valueOf(status.getProcessingNanos()));
        return metrics;
    }

    public Map<String, String> getProcessorTags(ProcessorStatus status) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("processor", status.getName());
        return tags;
    }

    public Map<String, Double> getPortStatusMetrics(PortStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("ActiveThreads", Double.valueOf(status.getActiveThreadCount().intValue()));
        metrics.put("InputCount", Double.valueOf(status.getInputCount()));
        metrics.put("OutputCount", Double.valueOf(status.getOutputCount()));
        metrics.put("InputBytes", Double.valueOf(status.getInputBytes()));
        metrics.put("OutputBytes", Double.valueOf(status.getOutputBytes()));
        metrics.put("FlowFilesReceivedLast5Minutes", Double.valueOf(status.getFlowFilesReceived()));
        metrics.put("FlowFilesSentLast5Minutes", Double.valueOf(status.getFlowFilesSent()));
        metrics.put("BytesReceivedLast5Minutes", Double.valueOf(status.getBytesReceived()));
        metrics.put("BytesSentLast5Minutes", Double.valueOf(status.getBytesSent()));
        return metrics;
    }

    public Map<String, Double> getConnectionStatusMetrics(ConnectionStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("InputCount", Double.valueOf(status.getInputCount()));
        metrics.put("InputBytes", Double.valueOf(status.getInputBytes()));
        metrics.put("QueuedCount", Double.valueOf(status.getQueuedCount()));
        metrics.put("QueuedBytes", Double.valueOf(status.getQueuedBytes()));
        metrics.put("OutputCount", Double.valueOf(status.getOutputCount()));
        metrics.put("OutputBytes", Double.valueOf(status.getOutputBytes()));
        return metrics;
    }

    public Map<String, Double> getDataFlowMetrics(ProcessGroupStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("FlowFilesReceivedLast5Minutes", Double.valueOf(status.getFlowFilesReceived()));
        metrics.put("BytesReceivedLast5Minutes", Double.valueOf(status.getBytesReceived()));
        metrics.put("FlowFilesSentLast5Minutes", Double.valueOf(status.getFlowFilesSent()));
        metrics.put("BytesSentLast5Minutes", Double.valueOf(status.getBytesSent()));
        metrics.put("FlowFilesQueued", Double.valueOf(status.getQueuedCount().intValue()));
        metrics.put("BytesQueued", Double.valueOf(status.getQueuedContentSize().longValue()));
        metrics.put("BytesReadLast5Minutes", Double.valueOf(status.getBytesRead().longValue()));
        metrics.put("BytesWrittenLast5Minutes", Double.valueOf(status.getBytesWritten().longValue()));
        metrics.put("ActiveThreads", Double.valueOf(status.getActiveThreadCount().intValue()));
        metrics.put("TotalTaskDurationSeconds", Double.valueOf(this.calculateProcessingNanos(status)));
        status.getOutputPortStatus();
        return metrics;
    }

    public Map<String, Double> getJVMMetrics(JmxJvmMetrics virtualMachineMetrics) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("jvm.uptime", Double.valueOf(virtualMachineMetrics.uptime()));
        metrics.put("jvm.heap_used", virtualMachineMetrics.heapUsed(DataUnit.B));
        metrics.put("jvm.heap_usage", virtualMachineMetrics.heapUsage());
        metrics.put("jvm.non_heap_usage", virtualMachineMetrics.nonHeapUsage());
        metrics.put("jvm.thread_count", Double.valueOf(virtualMachineMetrics.threadCount()));
        metrics.put("jvm.daemon_thread_count", Double.valueOf(virtualMachineMetrics.daemonThreadCount()));
        metrics.put("jvm.file_descriptor_usage", virtualMachineMetrics.fileDescriptorUsage());
        for (Map.Entry entry : virtualMachineMetrics.threadStatePercentages().entrySet()) {
            int normalizedValue = (int)(100.0 * (entry.getValue() == null ? 0.0 : (Double)entry.getValue()));
            switch ((Thread.State)((Object)entry.getKey())) {
                case BLOCKED: {
                    metrics.put("jvm.thread_states.blocked", Double.valueOf(normalizedValue));
                    break;
                }
                case RUNNABLE: {
                    metrics.put("jvm.thread_states.runnable", Double.valueOf(normalizedValue));
                    break;
                }
                case TERMINATED: {
                    metrics.put("jvm.thread_states.terminated", Double.valueOf(normalizedValue));
                    break;
                }
                case TIMED_WAITING: {
                    metrics.put("jvm.thread_states.timed_waiting", Double.valueOf(normalizedValue));
                    break;
                }
            }
        }
        for (Map.Entry entry : virtualMachineMetrics.garbageCollectors().entrySet()) {
            String gcName = ((String)entry.getKey()).replace(" ", "");
            long runs = ((JvmMetrics.GarbageCollectorStats)entry.getValue()).getRuns();
            long timeMS = ((JvmMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS);
            metrics.put("jvm.gc.runs." + gcName, Double.valueOf(runs));
            metrics.put("jvm.gc.time." + gcName, Double.valueOf(timeMS));
        }
        return metrics;
    }

    protected long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += this.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }
}

