/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cybersecurity.matchers;

import com.idealista.tlsh.digests.Digest;
import com.idealista.tlsh.digests.DigestBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.cybersecurity.CompareFuzzyHash;
import org.apache.nifi.processors.cybersecurity.matchers.FuzzyHashMatcher;

public class TLSHHashMatcher
implements FuzzyHashMatcher {
    ComponentLog logger;

    public TLSHHashMatcher(ComponentLog logger) {
        this.logger = logger;
    }

    @Override
    public BufferedReader getReader(String source) throws IOException {
        File file = new File(source);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream));
        return reader;
    }

    @Override
    public boolean matchExceedsThreshold(double similarity, double matchThreshold) {
        return similarity <= matchThreshold;
    }

    @Override
    public double getSimilarity(String inputHash, String existingHash) {
        String[] hashToCompare = existingHash.split("\t", 2);
        if (this.isValidHash(inputHash) && this.isValidHash(hashToCompare[0])) {
            Digest inputDigest = new DigestBuilder().withHash(inputHash).build();
            Digest existingHashDigest = new DigestBuilder().withHash(hashToCompare[0]).build();
            return inputDigest.calculateDifference(existingHashDigest, true);
        }
        return Double.NaN;
    }

    @Override
    public boolean isValidHash(String stringFromHashList) {
        String[] hashToCompare = stringFromHashList.split("\t", 2);
        if (hashToCompare.length > 0) {
            try {
                Digest digest = new DigestBuilder().withHash(hashToCompare[0]).build();
                return true;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException | StringIndexOutOfBoundsException e) {
                this.logger.error("Got {} while processing the string '{}'. This usually means the file defined by '{}' property contains invalid entries.", new Object[]{e.getCause(), hashToCompare[0], CompareFuzzyHash.HASH_LIST_FILE.getDisplayName()});
            }
        }
        return false;
    }

    @Override
    public String getHash(String line) {
        if (this.isValidHash(line)) {
            return line.split("\t", 2)[0];
        }
        return null;
    }

    @Override
    public String getMatch(String line) {
        String[] match;
        if (this.isValidHash(line) && (match = line.split("\t", 2)).length == 2) {
            return match[1];
        }
        return null;
    }
}

