/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schemaregistry.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.confluent.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.web.util.WebUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class RestSchemaRegistryClient
implements SchemaRegistryClient {
    private final List<String> baseUrls;
    private final Client client;
    private final ComponentLog logger;
    private final Map<String, String> httpHeaders;
    private static final String SUBJECT_FIELD_NAME = "subject";
    private static final String VERSION_FIELD_NAME = "version";
    private static final String ID_FIELD_NAME = "id";
    private static final String SCHEMA_TEXT_FIELD_NAME = "schema";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String SCHEMA_REGISTRY_CONTENT_TYPE = "application/vnd.schemaregistry.v1+json";

    public RestSchemaRegistryClient(List<String> baseUrls, int timeoutMillis, SSLContext sslContext, String username, String password, ComponentLog logger, Map<String, String> httpHeaders) {
        this.baseUrls = new ArrayList<String>(baseUrls);
        this.httpHeaders = httpHeaders;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)timeoutMillis);
        clientConfig.property("jersey.config.client.readTimeout", (Object)timeoutMillis);
        this.client = WebUtils.createClient((ClientConfig)clientConfig, (SSLContext)sslContext);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username, password})) {
            this.client.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
        }
        this.logger = logger;
    }

    @Override
    public RecordSchema getSchema(String schemaName) throws IOException, SchemaNotFoundException {
        String pathSuffix = this.getSubjectPath(schemaName, null);
        JsonNode responseJson = this.fetchJsonResponse(pathSuffix, "name " + schemaName);
        return this.createRecordSchema(responseJson);
    }

    @Override
    public RecordSchema getSchema(String schemaName, int schemaVersion) throws IOException, SchemaNotFoundException {
        String pathSuffix = this.getSubjectPath(schemaName, schemaVersion);
        JsonNode responseJson = this.fetchJsonResponse(pathSuffix, "name " + schemaName);
        return this.createRecordSchema(responseJson);
    }

    @Override
    public RecordSchema getSchema(int schemaId) throws IOException, SchemaNotFoundException {
        JsonNode schemaJson;
        String schemaPath;
        JsonNode completeSchema;
        block18: {
            completeSchema = null;
            schemaPath = this.getSchemaPath(schemaId);
            schemaJson = this.fetchJsonResponse(schemaPath, "id " + schemaId);
            JsonNode subjectsJson = null;
            try {
                subjectsJson = this.fetchJsonResponse(schemaPath + "/subjects", "schema name");
                if (subjectsJson == null) break block18;
                ArrayNode subjectsList = (ArrayNode)subjectsJson;
                for (JsonNode subject : subjectsList) {
                    String searchName = subject.asText();
                    try {
                        completeSchema = this.postJsonResponse("/subjects/" + searchName, schemaJson, "schema id: " + schemaId);
                        break;
                    }
                    catch (SchemaNotFoundException e) {
                        this.logger.debug("Could not find schema in registry by subject name " + searchName, (Throwable)e);
                    }
                }
            }
            catch (SchemaNotFoundException e) {
                this.logger.debug("Could not find schema metadata in registry by id and subjects in: " + schemaPath);
            }
        }
        if (completeSchema == null) {
            try {
                JsonNode subjectsVersions = this.fetchJsonResponse(schemaPath + "/versions", "schema name");
                if (subjectsVersions != null) {
                    ArrayNode subjectsVersionsList = (ArrayNode)subjectsVersions;
                    int maxVersion = 0;
                    String subjectName = null;
                    for (JsonNode subjectVersion : subjectsVersionsList) {
                        int currentVersion = subjectVersion.get(VERSION_FIELD_NAME).asInt();
                        String currentSubjectName = subjectVersion.get(SUBJECT_FIELD_NAME).asText();
                        if (currentVersion <= maxVersion) continue;
                        maxVersion = currentVersion;
                        subjectName = currentSubjectName;
                    }
                    if (subjectName != null) {
                        return this.createRecordSchema(subjectName, maxVersion, schemaId, schemaJson.get(SCHEMA_TEXT_FIELD_NAME).asText());
                    }
                }
            }
            catch (SchemaNotFoundException e) {
                this.logger.debug("Could not find schema metadata in registry by id and versions in: " + schemaPath);
            }
        }
        if (completeSchema == null) {
            try {
                JsonNode subjectsAllJson = this.fetchJsonResponse("/subjects", "subjects array");
                ArrayNode subjectsAllList = (ArrayNode)subjectsAllJson;
                for (JsonNode subject : subjectsAllList) {
                    try {
                        String searchName = subject.asText();
                        completeSchema = this.postJsonResponse("/subjects/" + searchName, schemaJson, "schema id: " + schemaId);
                        break;
                    }
                    catch (SchemaNotFoundException e) {
                    }
                }
            }
            catch (SchemaNotFoundException e) {
                this.logger.debug("Could not find schema metadata in registry by iterating through subjects");
            }
        }
        if (completeSchema == null) {
            return this.createRecordSchema(null, null, schemaId, schemaJson.get(SCHEMA_TEXT_FIELD_NAME).asText());
        }
        return this.createRecordSchema(completeSchema);
    }

    private RecordSchema createRecordSchema(String name, Integer version, int id, String schema) throws SchemaNotFoundException {
        try {
            Schema avroSchema = new Schema.Parser().parse(schema);
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(name).id(Long.valueOf(id)).version(version).build();
            return AvroTypeUtil.createSchema((Schema)avroSchema, (String)schema, (SchemaIdentifier)schemaId);
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema with id " + id + " and name " + name + " from Confluent Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }

    private RecordSchema createRecordSchema(JsonNode schemaNode) throws SchemaNotFoundException {
        String subject = schemaNode.get(SUBJECT_FIELD_NAME).asText();
        int version = schemaNode.get(VERSION_FIELD_NAME).asInt();
        int id = schemaNode.get(ID_FIELD_NAME).asInt();
        String schemaText = schemaNode.get(SCHEMA_TEXT_FIELD_NAME).asText();
        try {
            Schema avroSchema = new Schema.Parser().parse(schemaText);
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(subject).id(Long.valueOf(id)).version(Integer.valueOf(version)).build();
            return AvroTypeUtil.createSchema((Schema)avroSchema, (String)schemaText, (SchemaIdentifier)schemaId);
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema with id " + id + " and name " + subject + " from Confluent Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }

    private String getSubjectPath(String schemaName, Integer schemaVersion) throws UnsupportedEncodingException {
        return "/subjects/" + URLEncoder.encode(schemaName, "UTF-8") + "/versions/" + (schemaVersion == null ? "latest" : URLEncoder.encode(String.valueOf(schemaVersion), "UTF-8"));
    }

    private String getSchemaPath(int schemaId) throws UnsupportedEncodingException {
        return "/schemas/ids/" + URLEncoder.encode(String.valueOf(schemaId), "UTF-8");
    }

    private JsonNode postJsonResponse(String pathSuffix, JsonNode schema, String schemaDescription) throws SchemaNotFoundException {
        String errorMessage = null;
        block4: for (String baseUrl : this.baseUrls) {
            String path = this.getPath(pathSuffix);
            String trimmedBase = this.getTrimmedBase(baseUrl);
            String url = trimmedBase + path;
            this.logger.debug("POST JSON response URL {}", new Object[]{url});
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder builder = webTarget.request().accept(new String[]{"application/json"}).header(CONTENT_TYPE_HEADER, (Object)SCHEMA_REGISTRY_CONTENT_TYPE);
            for (Map.Entry<String, String> header : this.httpHeaders.entrySet()) {
                builder = builder.header(header.getKey(), (Object)header.getValue());
            }
            Response response = builder.post(Entity.json((Object)schema.toString()));
            int responseCode = response.getStatus();
            switch (Response.Status.fromStatusCode((int)responseCode)) {
                case OK: {
                    JsonNode jsonResponse = (JsonNode)response.readEntity(JsonNode.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("JSON Response: {}", new Object[]{jsonResponse});
                    }
                    return jsonResponse;
                }
                case NOT_FOUND: {
                    this.logger.debug("Could not find Schema {} from Registry {}", new Object[]{schemaDescription, baseUrl});
                    continue block4;
                }
            }
            errorMessage = (String)response.readEntity(String.class);
        }
        throw new SchemaNotFoundException("Failed to retrieve Schema with " + schemaDescription + " from any of the Confluent Schema Registry URL's provided; failure response message: " + errorMessage);
    }

    private JsonNode fetchJsonResponse(String pathSuffix, String schemaDescription) throws SchemaNotFoundException {
        String errorMessage = null;
        block4: for (String baseUrl : this.baseUrls) {
            String path = this.getPath(pathSuffix);
            String trimmedBase = this.getTrimmedBase(baseUrl);
            String url = trimmedBase + path;
            this.logger.debug("GET JSON response URL {}", new Object[]{url});
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder builder = webTarget.request().accept(new String[]{"application/json"});
            for (Map.Entry<String, String> header : this.httpHeaders.entrySet()) {
                builder = builder.header(header.getKey(), (Object)header.getValue());
            }
            Response response = builder.get();
            int responseCode = response.getStatus();
            switch (Response.Status.fromStatusCode((int)responseCode)) {
                case OK: {
                    JsonNode jsonResponse = (JsonNode)response.readEntity(JsonNode.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("JSON Response {}", new Object[]{jsonResponse});
                    }
                    return jsonResponse;
                }
                case NOT_FOUND: {
                    this.logger.debug("Could not find Schema {} from Registry {}", new Object[]{schemaDescription, baseUrl});
                    continue block4;
                }
            }
            errorMessage = (String)response.readEntity(String.class);
        }
        throw new SchemaNotFoundException("Failed to retrieve Schema with " + schemaDescription + " from any of the Confluent Schema Registry URL's provided; failure response message: " + errorMessage);
    }

    private String getTrimmedBase(String baseUrl) {
        return baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    private String getPath(String pathSuffix) {
        return pathSuffix.startsWith("/") ? pathSuffix : "/" + pathSuffix;
    }
}

