/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.annotations.ApiModelProperty;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.status.ConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodeConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="connectionStatus")
public class ConnectionStatusDTO
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private Date statsLastRefreshed;
    private String sourceId;
    private String sourceName;
    private String destinationId;
    private String destinationName;
    private ConnectionStatusSnapshotDTO aggregateSnapshot;
    private List<NodeConnectionStatusSnapshotDTO> nodeSnapshots;

    @ApiModelProperty(value="The ID of the connection")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The ID of the Process Group that the connection belongs to")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The name of the connection")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The ID of the source component")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @ApiModelProperty(value="The name of the source component")
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @ApiModelProperty(value="The ID of the destination component")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    @ApiModelProperty(value="The name of the destination component")
    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    @ApiModelProperty(value="The status snapshot that represents the aggregate stats of the cluster")
    public ConnectionStatusSnapshotDTO getAggregateSnapshot() {
        return this.aggregateSnapshot;
    }

    public void setAggregateSnapshot(ConnectionStatusSnapshotDTO aggregateSnapshot) {
        this.aggregateSnapshot = aggregateSnapshot;
    }

    @ApiModelProperty(value="A list of status snapshots for each node")
    public List<NodeConnectionStatusSnapshotDTO> getNodeSnapshots() {
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(List<NodeConnectionStatusSnapshotDTO> nodeSnapshots) {
        this.nodeSnapshots = nodeSnapshots;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @ApiModelProperty(value="The timestamp of when the stats were last refreshed", dataType="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }

    public ConnectionStatusDTO clone() {
        ConnectionStatusDTO other = new ConnectionStatusDTO();
        other.setDestinationId(this.getDestinationId());
        other.setDestinationName(this.getDestinationName());
        other.setGroupId(this.getGroupId());
        other.setId(this.getId());
        other.setName(this.getName());
        other.setSourceId(this.getSourceId());
        other.setSourceName(this.getSourceName());
        other.setAggregateSnapshot(this.getAggregateSnapshot().clone());
        List<NodeConnectionStatusSnapshotDTO> nodeStatuses = this.getNodeSnapshots();
        ArrayList<NodeConnectionStatusSnapshotDTO> nodeStatusClones = new ArrayList<NodeConnectionStatusSnapshotDTO>(nodeStatuses.size());
        for (NodeConnectionStatusSnapshotDTO nodeStatus : nodeStatuses) {
            nodeStatusClones.add(nodeStatus.clone());
        }
        other.setNodeSnapshots(nodeStatusClones);
        return other;
    }
}

