/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="systemDiagnosticsSnapshot")
public class SystemDiagnosticsSnapshotDTO
implements Cloneable {
    private String totalNonHeap;
    private Long totalNonHeapBytes;
    private String usedNonHeap;
    private Long usedNonHeapBytes;
    private String freeNonHeap;
    private Long freeNonHeapBytes;
    private String maxNonHeap;
    private Long maxNonHeapBytes;
    private String nonHeapUtilization;
    private String totalHeap;
    private Long totalHeapBytes;
    private String usedHeap;
    private Long usedHeapBytes;
    private String freeHeap;
    private Long freeHeapBytes;
    private String maxHeap;
    private Long maxHeapBytes;
    private String heapUtilization;
    private Integer availableProcessors;
    private Double processorLoadAverage;
    private Integer totalThreads;
    private Integer daemonThreads;
    private String uptime;
    private StorageUsageDTO flowFileRepositoryStorageUsage;
    private Set<StorageUsageDTO> contentRepositoryStorageUsage;
    private Set<StorageUsageDTO> provenanceRepositoryStorageUsage;
    private Set<GarbageCollectionDTO> garbageCollection;
    private Date statsLastRefreshed;
    private VersionInfoDTO versionInfo;

    @ApiModelProperty(value="Number of available processors if supported by the underlying system.")
    public Integer getAvailableProcessors() {
        return this.availableProcessors;
    }

    public void setAvailableProcessors(Integer availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    @ApiModelProperty(value="Number of daemon threads.")
    public Integer getDaemonThreads() {
        return this.daemonThreads;
    }

    public void setDaemonThreads(Integer daemonThreads) {
        this.daemonThreads = daemonThreads;
    }

    @ApiModelProperty(value="Amount of free heap.")
    public String getFreeHeap() {
        return this.freeHeap;
    }

    public void setFreeHeap(String freeHeap) {
        this.freeHeap = freeHeap;
    }

    @ApiModelProperty(value="Amount of free non heap.")
    public String getFreeNonHeap() {
        return this.freeNonHeap;
    }

    public void setFreeNonHeap(String freeNonHeap) {
        this.freeNonHeap = freeNonHeap;
    }

    @ApiModelProperty(value="Maximum size of heap.")
    public String getMaxHeap() {
        return this.maxHeap;
    }

    public void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    @ApiModelProperty(value="Maximum size of non heap.")
    public String getMaxNonHeap() {
        return this.maxNonHeap;
    }

    public void setMaxNonHeap(String maxNonHeap) {
        this.maxNonHeap = maxNonHeap;
    }

    @ApiModelProperty(value="The processor load average if supported by the underlying system.")
    public Double getProcessorLoadAverage() {
        return this.processorLoadAverage;
    }

    public void setProcessorLoadAverage(Double processorLoadAverage) {
        this.processorLoadAverage = processorLoadAverage;
    }

    @ApiModelProperty(value="Total size of heap.")
    public String getTotalHeap() {
        return this.totalHeap;
    }

    public void setTotalHeap(String totalHeap) {
        this.totalHeap = totalHeap;
    }

    @ApiModelProperty(value="Total size of non heap.")
    public String getTotalNonHeap() {
        return this.totalNonHeap;
    }

    public void setTotalNonHeap(String totalNonHeap) {
        this.totalNonHeap = totalNonHeap;
    }

    @ApiModelProperty(value="Total number of threads.")
    public Integer getTotalThreads() {
        return this.totalThreads;
    }

    public void setTotalThreads(Integer totalThreads) {
        this.totalThreads = totalThreads;
    }

    @ApiModelProperty(value="Amount of used heap.")
    public String getUsedHeap() {
        return this.usedHeap;
    }

    public void setUsedHeap(String usedHeap) {
        this.usedHeap = usedHeap;
    }

    @ApiModelProperty(value="Amount of use non heap.")
    public String getUsedNonHeap() {
        return this.usedNonHeap;
    }

    public void setUsedNonHeap(String usedNonHeap) {
        this.usedNonHeap = usedNonHeap;
    }

    @ApiModelProperty(value="Utilization of heap.")
    public String getHeapUtilization() {
        return this.heapUtilization;
    }

    public void setHeapUtilization(String heapUtilization) {
        this.heapUtilization = heapUtilization;
    }

    @ApiModelProperty(value="Utilization of non heap.")
    public String getNonHeapUtilization() {
        return this.nonHeapUtilization;
    }

    public void setNonHeapUtilization(String nonHeapUsage) {
        this.nonHeapUtilization = nonHeapUsage;
    }

    @ApiModelProperty(value="The content repository storage usage.")
    public Set<StorageUsageDTO> getContentRepositoryStorageUsage() {
        return this.contentRepositoryStorageUsage;
    }

    public void setContentRepositoryStorageUsage(Set<StorageUsageDTO> contentRepositoryStorageUsage) {
        this.contentRepositoryStorageUsage = contentRepositoryStorageUsage;
    }

    @ApiModelProperty(value="The provenance repository storage usage.")
    public Set<StorageUsageDTO> getProvenanceRepositoryStorageUsage() {
        return this.provenanceRepositoryStorageUsage;
    }

    public void setProvenanceRepositoryStorageUsage(Set<StorageUsageDTO> provenanceRepositoryStorageUsage) {
        this.provenanceRepositoryStorageUsage = provenanceRepositoryStorageUsage;
    }

    @ApiModelProperty(value="The flowfile repository storage usage.")
    public StorageUsageDTO getFlowFileRepositoryStorageUsage() {
        return this.flowFileRepositoryStorageUsage;
    }

    public void setFlowFileRepositoryStorageUsage(StorageUsageDTO flowFileRepositoryStorageUsage) {
        this.flowFileRepositoryStorageUsage = flowFileRepositoryStorageUsage;
    }

    @ApiModelProperty(value="The garbage collection details.")
    public Set<GarbageCollectionDTO> getGarbageCollection() {
        return this.garbageCollection;
    }

    public void setGarbageCollection(Set<GarbageCollectionDTO> garbageCollection) {
        this.garbageCollection = garbageCollection;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @ApiModelProperty(value="When the diagnostics were generated.", dataType="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }

    @ApiModelProperty(value="Total number of bytes allocated to the JVM not used for heap")
    public Long getTotalNonHeapBytes() {
        return this.totalNonHeapBytes;
    }

    public void setTotalNonHeapBytes(Long totalNonHeapBytes) {
        this.totalNonHeapBytes = totalNonHeapBytes;
    }

    @ApiModelProperty(value="Total number of bytes used by the JVM not in the heap space")
    public Long getUsedNonHeapBytes() {
        return this.usedNonHeapBytes;
    }

    public void setUsedNonHeapBytes(Long usedNonHeapBytes) {
        this.usedNonHeapBytes = usedNonHeapBytes;
    }

    @ApiModelProperty(value="Total number of free non-heap bytes available to the JVM")
    public Long getFreeNonHeapBytes() {
        return this.freeNonHeapBytes;
    }

    public void setFreeNonHeapBytes(Long freeNonHeapBytes) {
        this.freeNonHeapBytes = freeNonHeapBytes;
    }

    @ApiModelProperty(value="The maximum number of bytes that the JVM can use for non-heap purposes")
    public Long getMaxNonHeapBytes() {
        return this.maxNonHeapBytes;
    }

    public void setMaxNonHeapBytes(Long maxNonHeapBytes) {
        this.maxNonHeapBytes = maxNonHeapBytes;
    }

    @ApiModelProperty(value="The total number of bytes that are available for the JVM heap to use")
    public Long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    public void setTotalHeapBytes(Long totalHeapBytes) {
        this.totalHeapBytes = totalHeapBytes;
    }

    @ApiModelProperty(value="The number of bytes of JVM heap that are currently being used")
    public Long getUsedHeapBytes() {
        return this.usedHeapBytes;
    }

    public void setUsedHeapBytes(Long usedHeapBytes) {
        this.usedHeapBytes = usedHeapBytes;
    }

    @ApiModelProperty(value="The number of bytes that are allocated to the JVM heap but not currently being used")
    public Long getFreeHeapBytes() {
        return this.freeHeapBytes;
    }

    public void setFreeHeapBytes(Long freeHeapBytes) {
        this.freeHeapBytes = freeHeapBytes;
    }

    @ApiModelProperty(value="The maximum number of bytes that can be used by the JVM")
    public Long getMaxHeapBytes() {
        return this.maxHeapBytes;
    }

    public void setMaxHeapBytes(Long maxHeapBytes) {
        this.maxHeapBytes = maxHeapBytes;
    }

    @ApiModelProperty(value="The nifi, os, java, and build version information")
    public VersionInfoDTO getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfoDTO versionInfo) {
        this.versionInfo = versionInfo;
    }

    @ApiModelProperty(value="The uptime of the Java virtual machine")
    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public SystemDiagnosticsSnapshotDTO clone() {
        SystemDiagnosticsSnapshotDTO other = new SystemDiagnosticsSnapshotDTO();
        other.setAvailableProcessors(this.getAvailableProcessors());
        other.setDaemonThreads(this.getDaemonThreads());
        other.setFreeHeap(this.getFreeHeap());
        other.setFreeHeapBytes(this.getFreeHeapBytes());
        other.setFreeNonHeap(this.getFreeNonHeap());
        other.setFreeNonHeapBytes(this.getFreeNonHeapBytes());
        other.setHeapUtilization(this.getHeapUtilization());
        other.setMaxHeap(this.getMaxHeap());
        other.setMaxHeapBytes(this.getMaxHeapBytes());
        other.setMaxNonHeap(this.getMaxNonHeap());
        other.setMaxNonHeapBytes(this.getMaxNonHeapBytes());
        other.setNonHeapUtilization(this.getNonHeapUtilization());
        other.setProcessorLoadAverage(this.getProcessorLoadAverage());
        other.setStatsLastRefreshed(this.getStatsLastRefreshed());
        other.setTotalHeap(this.getTotalHeap());
        other.setTotalHeapBytes(this.getTotalHeapBytes());
        other.setTotalNonHeap(this.getTotalNonHeap());
        other.setTotalNonHeapBytes(this.getTotalNonHeapBytes());
        other.setTotalThreads(this.getTotalThreads());
        other.setUsedHeap(this.getUsedHeap());
        other.setUsedHeapBytes(this.getUsedHeapBytes());
        other.setUsedNonHeap(this.getUsedNonHeap());
        other.setUsedNonHeapBytes(this.getUsedNonHeapBytes());
        other.setFlowFileRepositoryStorageUsage(this.getFlowFileRepositoryStorageUsage().clone());
        LinkedHashSet<StorageUsageDTO> contentRepoStorageUsage = new LinkedHashSet<StorageUsageDTO>();
        other.setContentRepositoryStorageUsage(contentRepoStorageUsage);
        if (this.getContentRepositoryStorageUsage() != null) {
            for (StorageUsageDTO storageUsageDTO : this.getContentRepositoryStorageUsage()) {
                contentRepoStorageUsage.add(storageUsageDTO.clone());
            }
        }
        LinkedHashSet<StorageUsageDTO> provenanceRepoStorageUsage = new LinkedHashSet<StorageUsageDTO>();
        other.setProvenanceRepositoryStorageUsage(provenanceRepoStorageUsage);
        if (this.getProvenanceRepositoryStorageUsage() != null) {
            for (StorageUsageDTO usage : this.getProvenanceRepositoryStorageUsage()) {
                provenanceRepoStorageUsage.add(usage.clone());
            }
        }
        LinkedHashSet<GarbageCollectionDTO> linkedHashSet = new LinkedHashSet<GarbageCollectionDTO>();
        other.setGarbageCollection(linkedHashSet);
        if (this.getGarbageCollection() != null) {
            for (GarbageCollectionDTO gcDto : this.getGarbageCollection()) {
                linkedHashSet.add(gcDto.clone());
            }
        }
        other.setVersionInfo(this.getVersionInfo().clone());
        other.setUptime(this.getUptime());
        return other;
    }

    @XmlType(name="storageUsage")
    public static class StorageUsageDTO
    implements Cloneable {
        private String identifier;
        private String freeSpace;
        private String totalSpace;
        private String usedSpace;
        private Long freeSpaceBytes;
        private Long totalSpaceBytes;
        private Long usedSpaceBytes;
        private String utilization;

        @ApiModelProperty(value="The identifier of this storage location. The identifier will correspond to the identifier keyed in the storage configuration.")
        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @ApiModelProperty(value="Amount of free space.")
        public String getFreeSpace() {
            return this.freeSpace;
        }

        public void setFreeSpace(String freeSpace) {
            this.freeSpace = freeSpace;
        }

        @ApiModelProperty(value="Amount of total space.")
        public String getTotalSpace() {
            return this.totalSpace;
        }

        public void setTotalSpace(String totalSpace) {
            this.totalSpace = totalSpace;
        }

        @ApiModelProperty(value="Amount of used space.")
        public String getUsedSpace() {
            return this.usedSpace;
        }

        public void setUsedSpace(String usedSpace) {
            this.usedSpace = usedSpace;
        }

        @ApiModelProperty(value="Utilization of this storage location.")
        public String getUtilization() {
            return this.utilization;
        }

        public void setUtilization(String utilization) {
            this.utilization = utilization;
        }

        @ApiModelProperty(value="The number of bytes of free space.")
        public Long getFreeSpaceBytes() {
            return this.freeSpaceBytes;
        }

        public void setFreeSpaceBytes(Long freeSpaceBytes) {
            this.freeSpaceBytes = freeSpaceBytes;
        }

        @ApiModelProperty(value="The number of bytes of total space.")
        public Long getTotalSpaceBytes() {
            return this.totalSpaceBytes;
        }

        public void setTotalSpaceBytes(Long totalSpaceBytes) {
            this.totalSpaceBytes = totalSpaceBytes;
        }

        @ApiModelProperty(value="The number of bytes of used space.")
        public Long getUsedSpaceBytes() {
            return this.usedSpaceBytes;
        }

        public void setUsedSpaceBytes(Long usedSpaceBytes) {
            this.usedSpaceBytes = usedSpaceBytes;
        }

        public StorageUsageDTO clone() {
            StorageUsageDTO other = new StorageUsageDTO();
            other.setIdentifier(this.getIdentifier());
            other.setFreeSpace(this.getFreeSpace());
            other.setTotalSpace(this.getTotalSpace());
            other.setUsedSpace(this.getUsedSpace());
            other.setFreeSpaceBytes(this.getFreeSpaceBytes());
            other.setTotalSpaceBytes(this.getTotalSpaceBytes());
            other.setUsedSpaceBytes(this.getUsedSpaceBytes());
            other.setUtilization(this.getUtilization());
            return other;
        }
    }

    @XmlType(name="versionInfo")
    public static class VersionInfoDTO
    implements Cloneable {
        private String niFiVersion;
        private String javaVendor;
        private String javaVersion;
        private String osName;
        private String osVersion;
        private String osArchitecture;
        private String buildTag;
        private String buildRevision;
        private String buildBranch;
        private Date buildTimestamp;

        @ApiModelProperty(value="The version of this NiFi.")
        public String getNiFiVersion() {
            return this.niFiVersion;
        }

        public void setNiFiVersion(String niFiVersion) {
            this.niFiVersion = niFiVersion;
        }

        @ApiModelProperty(value="Java JVM vendor")
        public String getJavaVendor() {
            return this.javaVendor;
        }

        public void setJavaVendor(String javaVendor) {
            this.javaVendor = javaVendor;
        }

        @ApiModelProperty(value="Java version")
        public String getJavaVersion() {
            return this.javaVersion;
        }

        public void setJavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
        }

        @ApiModelProperty(value="Host operating system name")
        public String getOsName() {
            return this.osName;
        }

        public void setOsName(String osName) {
            this.osName = osName;
        }

        @ApiModelProperty(value="Host operating system version")
        public String getOsVersion() {
            return this.osVersion;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @ApiModelProperty(value="Host operating system architecture")
        public String getOsArchitecture() {
            return this.osArchitecture;
        }

        public void setOsArchitecture(String osArchitecture) {
            this.osArchitecture = osArchitecture;
        }

        @ApiModelProperty(value="Build tag")
        public String getBuildTag() {
            return this.buildTag;
        }

        public void setBuildTag(String buildTag) {
            this.buildTag = buildTag;
        }

        @ApiModelProperty(value="Build revision or commit hash")
        public String getBuildRevision() {
            return this.buildRevision;
        }

        public void setBuildRevision(String buildRevision) {
            this.buildRevision = buildRevision;
        }

        @ApiModelProperty(value="Build branch")
        public String getBuildBranch() {
            return this.buildBranch;
        }

        public void setBuildBranch(String buildBranch) {
            this.buildBranch = buildBranch;
        }

        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        @ApiModelProperty(value="Build timestamp")
        public Date getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public void setBuildTimestamp(Date buildTimestamp) {
            this.buildTimestamp = buildTimestamp;
        }

        public VersionInfoDTO clone() {
            VersionInfoDTO other = new VersionInfoDTO();
            other.setNiFiVersion(this.getNiFiVersion());
            other.setJavaVendor(this.getJavaVendor());
            other.setJavaVersion(this.getJavaVersion());
            other.setOsName(this.getOsName());
            other.setOsVersion(this.getOsVersion());
            other.setOsArchitecture(this.getOsArchitecture());
            other.setBuildTag(this.getBuildTag());
            other.setBuildTimestamp(this.getBuildTimestamp());
            other.setBuildBranch(this.getBuildBranch());
            other.setBuildRevision(this.getBuildRevision());
            return other;
        }
    }

    @XmlType(name="garbageCollection")
    public static class GarbageCollectionDTO
    implements Cloneable {
        private String name;
        private long collectionCount;
        private String collectionTime;
        private Long collectionMillis;

        @ApiModelProperty(value="The name of the garbage collector.")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ApiModelProperty(value="The number of times garbage collection has run.")
        public long getCollectionCount() {
            return this.collectionCount;
        }

        public void setCollectionCount(long collectionCount) {
            this.collectionCount = collectionCount;
        }

        @ApiModelProperty(value="The total amount of time spent garbage collecting.")
        public String getCollectionTime() {
            return this.collectionTime;
        }

        public void setCollectionTime(String collectionTime) {
            this.collectionTime = collectionTime;
        }

        @ApiModelProperty(value="The total number of milliseconds spent garbage collecting.")
        public Long getCollectionMillis() {
            return this.collectionMillis;
        }

        public void setCollectionMillis(Long collectionMillis) {
            this.collectionMillis = collectionMillis;
        }

        public GarbageCollectionDTO clone() {
            GarbageCollectionDTO other = new GarbageCollectionDTO();
            other.setName(this.getName());
            other.setCollectionCount(this.getCollectionCount());
            other.setCollectionTime(this.getCollectionTime());
            other.setCollectionMillis(this.getCollectionMillis());
            return other;
        }
    }
}

