/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.encoded;

import java.nio.charset.StandardCharsets;
import org.apache.nifi.components.DescribedValue;

public enum EncodedDelimiter implements DescribedValue
{
    SALT("NiFiSALT", "Eight bytes appended to a stream after the salt bytes according to NiFi 0.5.0 conventions"),
    IV("NiFiIV", "Six bytes appended to a stream after the initialization vector bytes according to NiFi 0.5.0 conventions");

    private final byte[] delimiter;
    private final String description;

    private EncodedDelimiter(String delimiterEncoded, String description) {
        this.delimiter = delimiterEncoded.getBytes(StandardCharsets.UTF_8);
        this.description = description;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }
}

