/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.cipher.CipherException;
import org.apache.nifi.processors.cipher.algorithm.CipherAlgorithmMode;
import org.apache.nifi.processors.cipher.algorithm.CipherAlgorithmPadding;
import org.apache.nifi.processors.cipher.algorithm.SymmetricCipher;
import org.apache.nifi.processors.cipher.encoded.EncodedDelimiter;
import org.apache.nifi.processors.cipher.encoded.KeySpecificationFormat;
import org.apache.nifi.processors.cipher.io.DecryptStreamCallback;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.StandardDerivedKeySpec;
import org.apache.nifi.security.crypto.key.detection.DetectedDerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.detection.DetectedDerivedKeyProvider;
import org.apache.nifi.security.crypto.key.io.ByteBufferSearch;
import org.bouncycastle.shaded.util.encoders.Hex;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"cryptography", "decipher", "decrypt", "AES", "Argon2", "bcrypt", "scrypt", "PBKDF2"})
@CapabilityDescription(value="Decrypt content encrypted with AES and encoded according conventions added in NiFi 0.5.0 for the EncryptContent Processor. The Processor reads the first 256 bytes to determine the presence of a cryptographic salt based on finding the 'NiFiSALT' delimiter. The salt is not present for content encrypted with a raw hexadecimal key. The Processor determines the presence of the initialization vector based on finding the 'NiFiIV' delimiter.The salt format indicates the Key Derivation Function that the Processor uses to generate a secret key based on a configured password. The Processor derives keys with a size of 128 bits according to the conventions implemented in NiFi 0.5.0.")
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class DecryptContent
extends AbstractProcessor {
    static final PropertyDescriptor CIPHER_ALGORITHM_MODE = new PropertyDescriptor.Builder().name("cipher-algorithm-mode").displayName("Cipher Algorithm Mode").description("Block cipher mode of operation for decryption using the Advanced Encryption Standard").required(true).allowableValues(CipherAlgorithmMode.class).defaultValue(CipherAlgorithmMode.GCM.getValue()).build();
    static final PropertyDescriptor CIPHER_ALGORITHM_PADDING = new PropertyDescriptor.Builder().name("cipher-algorithm-padding").displayName("Cipher Algorithm Padding").description("Padding specification used in cipher operation for decryption using the Advanced Encryption Standard").required(true).allowableValues(CipherAlgorithmPadding.class).defaultValue(CipherAlgorithmPadding.NO_PADDING.getValue()).build();
    static final PropertyDescriptor KEY_SPECIFICATION_FORMAT = new PropertyDescriptor.Builder().name("key-specification-format").displayName("Key Specification Format").description("Format describing the configured Key Specification").required(true).allowableValues(KeySpecificationFormat.class).defaultValue(KeySpecificationFormat.PASSWORD.getValue()).build();
    static final PropertyDescriptor KEY_SPECIFICATION = new PropertyDescriptor.Builder().name("key-specification").displayName("Key Specification").description("Specification providing the raw secret key or a password from which to derive a secret key").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Decryption succeeded").build();
    static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Decryption failed").build();
    private static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(CIPHER_ALGORITHM_MODE, CIPHER_ALGORITHM_PADDING, KEY_SPECIFICATION_FORMAT, KEY_SPECIFICATION));
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE)));
    private static final SymmetricCipher SYMMETRIC_CIPHER = SymmetricCipher.AES;
    private static final String TRANSFORMATION_FORMAT = "%s/%s/%s";

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String specificationFormat = context.getProperty(KEY_SPECIFICATION_FORMAT).getValue();
        KeySpecificationFormat keySpecificationFormat = KeySpecificationFormat.valueOf(specificationFormat);
        String cipherTransformation = this.getCipherTransformation(context);
        Cipher cipher = this.getCipher(cipherTransformation);
        String algorithmMode = context.getProperty(CIPHER_ALGORITHM_MODE).getValue();
        CipherAlgorithmMode cipherAlgorithmMode = CipherAlgorithmMode.valueOf(algorithmMode);
        KeySpec keySpec = this.getKeySpec(context, keySpecificationFormat);
        DecryptCallback callback = new DecryptCallback(cipher, cipherAlgorithmMode, keySpec);
        try {
            flowFile = session.write(flowFile, (StreamCallback)callback);
            this.getLogger().debug("Decryption completed using [{}] {}", new Object[]{cipherTransformation, flowFile});
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Decryption failed using [{}] {}", new Object[]{cipherTransformation, flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    private String getCipherTransformation(ProcessContext context) {
        String algorithmMode = context.getProperty(CIPHER_ALGORITHM_MODE).getValue();
        String algorithmPadding = context.getProperty(CIPHER_ALGORITHM_PADDING).getValue();
        return String.format(TRANSFORMATION_FORMAT, SYMMETRIC_CIPHER.getValue(), algorithmMode, algorithmPadding);
    }

    private Cipher getCipher(String transformation) {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (GeneralSecurityException e) {
            String message = String.format("Cipher [%s] not found", transformation);
            throw new CipherException(message, e);
        }
    }

    private KeySpec getKeySpec(ProcessContext context, KeySpecificationFormat keySpecificationFormat) {
        KeySpec keySpec;
        String keySpecification = context.getProperty(KEY_SPECIFICATION).getValue();
        if (KeySpecificationFormat.RAW == keySpecificationFormat) {
            byte[] decodedKey = Hex.decode((String)keySpecification);
            keySpec = new SecretKeySpec(decodedKey, SYMMETRIC_CIPHER.getValue());
        } else {
            char[] password = keySpecification.toCharArray();
            keySpec = new PBEKeySpec(password);
        }
        return keySpec;
    }

    private static class DecryptCallback
    extends DecryptStreamCallback {
        private static final int PARAMETERS_BUFFER_LENGTH = 256;
        private static final int DERIVED_KEY_LENGTH_BYTES = 16;
        private static final int END_OF_FILE = -1;
        private static final byte[] EMPTY_BYTES = new byte[0];
        private static final DetectedDerivedKeyParameterSpecReader parameterSpecReader = new DetectedDerivedKeyParameterSpecReader();
        private static final DetectedDerivedKeyProvider derivedKeyProvider = new DetectedDerivedKeyProvider();
        private final CipherAlgorithmMode cipherAlgorithmMode;
        private final KeySpec keySpec;

        private DecryptCallback(Cipher cipher, CipherAlgorithmMode cipherAlgorithmMode, KeySpec keySpec) {
            super(cipher, 256);
            this.cipherAlgorithmMode = cipherAlgorithmMode;
            this.keySpec = keySpec;
        }

        @Override
        protected AlgorithmParameterSpec readAlgorithmParameterSpec(ByteBuffer parameterBuffer) {
            byte[] salt = this.readDelimitedBytes(parameterBuffer, EncodedDelimiter.SALT);
            byte[] iv = this.readDelimitedBytes(parameterBuffer, EncodedDelimiter.IV);
            AlgorithmParameterSpec spec = CipherAlgorithmMode.GCM == this.cipherAlgorithmMode ? new GCMSerializedParameterSpec(iv, salt) : new IvSerializedParameterSpec(iv, salt);
            return spec;
        }

        @Override
        protected Key getKey(AlgorithmParameterSpec algorithmParameterSpec) {
            Key key;
            if (this.keySpec instanceof SecretKeySpec) {
                key = (SecretKeySpec)this.keySpec;
            } else if (algorithmParameterSpec instanceof SerializedParameterSpec) {
                SerializedParameterSpec serializedParameterSpec = (SerializedParameterSpec)((Object)algorithmParameterSpec);
                byte[] parameters = serializedParameterSpec.getParameters();
                key = this.getDerivedKey(parameters);
            } else {
                String message = String.format("Key Derivation Function Parameters not provided [%s]", algorithmParameterSpec.getClass());
                throw new IllegalArgumentException(message);
            }
            return key;
        }

        private Key getDerivedKey(byte[] parameters) {
            DerivedKeyParameterSpec derivedKeyParameterSpec = parameterSpecReader.read(parameters);
            DerivedKeySpec<DerivedKeyParameterSpec> derivedKeySpec = this.getDerivedKeySpec(derivedKeyParameterSpec);
            return derivedKeyProvider.getDerivedKey(derivedKeySpec);
        }

        private DerivedKeySpec<DerivedKeyParameterSpec> getDerivedKeySpec(DerivedKeyParameterSpec parameterSpec) {
            PBEKeySpec pbeKeySpec = (PBEKeySpec)this.keySpec;
            char[] password = pbeKeySpec.getPassword();
            return new StandardDerivedKeySpec(password, 16, SYMMETRIC_CIPHER.getValue(), parameterSpec);
        }

        private byte[] readDelimitedBytes(ByteBuffer buffer, EncodedDelimiter encodedDelimiter) {
            byte[] delimitedBytes;
            byte[] delimiter = encodedDelimiter.getDelimiter();
            int delimiterIndex = ByteBufferSearch.indexOf((ByteBuffer)buffer, (byte[])delimiter);
            if (delimiterIndex == -1) {
                delimitedBytes = EMPTY_BYTES;
            } else {
                int delimitedLength = delimiterIndex - buffer.position();
                delimitedBytes = new byte[delimitedLength];
                buffer.get(delimitedBytes);
                int newPosition = delimiterIndex + delimiter.length;
                buffer.position(newPosition);
            }
            return delimitedBytes;
        }
    }

    private static class IvSerializedParameterSpec
    extends IvParameterSpec
    implements SerializedParameterSpec {
        private final byte[] parameters;

        private IvSerializedParameterSpec(byte[] iv, byte[] parameters) {
            super(iv);
            this.parameters = parameters;
        }

        @Override
        public byte[] getParameters() {
            return this.parameters;
        }
    }

    private static class GCMSerializedParameterSpec
    extends GCMParameterSpec
    implements SerializedParameterSpec {
        private static final int GCM_TAG_LENGTH_BITS = 128;
        private final byte[] parameters;

        private GCMSerializedParameterSpec(byte[] iv, byte[] parameters) {
            super(128, iv);
            this.parameters = parameters;
        }

        @Override
        public byte[] getParameters() {
            return this.parameters;
        }
    }

    private static interface SerializedParameterSpec {
        public byte[] getParameters();
    }
}

