/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.cipher.CipherException;
import org.apache.nifi.processors.cipher.compatibility.CompatibilityModeEncryptionScheme;
import org.apache.nifi.processors.cipher.compatibility.CompatibilityModeKeyDerivationStrategy;
import org.apache.nifi.processors.cipher.io.DecryptStreamCallback;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"cryptography", "decipher", "decrypt", "Jasypt", "OpenSSL", "PKCS5", "PBES1"})
@CapabilityDescription(value="Decrypt content using password-based encryption schemes with legacy algorithms supporting historical compatibility modes.")
@WritesAttributes(value={@WritesAttribute(attribute="pbe.scheme", description="Password-Based Encryption Scheme"), @WritesAttribute(attribute="pbe.symmetric.cipher", description="Password-Based Encryption Block Cipher"), @WritesAttribute(attribute="pbe.digest.algorithm", description="Password-Based Encryption Digest Algorithm")})
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class DecryptContentCompatibility
extends AbstractProcessor {
    static final PropertyDescriptor ENCRYPTION_SCHEME = new PropertyDescriptor.Builder().name("encryption-scheme").displayName("Encryption Scheme").description("Password-Based Encryption Scheme including PBES1 described in RFC 8018, and others defined according to PKCS12 and Bouncy Castle implementations").required(true).allowableValues(CompatibilityModeEncryptionScheme.class).build();
    static final PropertyDescriptor KEY_DERIVATION_STRATEGY = new PropertyDescriptor.Builder().name("key-derivation-strategy").displayName("Key Derivation Strategy").description("Strategy for reading salt from encoded contents and deriving the decryption key according to the number of function iterations").required(true).allowableValues(CompatibilityModeKeyDerivationStrategy.class).build();
    static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("password").displayName("Password").description("Password required for Password-Based Encryption Schemes").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Decryption succeeded").build();
    static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Decryption failed").build();
    private static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_SCHEME, KEY_DERIVATION_STRATEGY, PASSWORD));
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE)));
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String scheme = context.getProperty(ENCRYPTION_SCHEME).getValue();
        CompatibilityModeEncryptionScheme encryptionScheme = this.getEncryptionScheme(scheme);
        Cipher cipher = this.getCipher(scheme);
        char[] password = context.getProperty(PASSWORD).getValue().toCharArray();
        PBEKeySpec keySpec = new PBEKeySpec(password);
        String strategy = context.getProperty(KEY_DERIVATION_STRATEGY).getValue();
        CompatibilityModeKeyDerivationStrategy keyDerivationStrategy = CompatibilityModeKeyDerivationStrategy.valueOf(strategy);
        DecryptCallback callback = new DecryptCallback(cipher, keySpec, keyDerivationStrategy);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("pbe.scheme", encryptionScheme.getValue());
        attributes.put("pbe.symmetric.cipher", encryptionScheme.getSymmetricCipher().getValue());
        attributes.put("pbe.digest.algorithm", encryptionScheme.getDigestAlgorithm().getValue());
        try {
            flowFile = session.write(flowFile, (StreamCallback)callback);
            flowFile = session.putAllAttributes(flowFile, attributes);
            this.getLogger().debug("Decryption completed using [{}] {}", new Object[]{scheme, flowFile});
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Decryption failed using [{}] {}", new Object[]{scheme, flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    private CompatibilityModeEncryptionScheme getEncryptionScheme(String scheme) {
        Optional<CompatibilityModeEncryptionScheme> encryptionSchemeFound = Arrays.stream(CompatibilityModeEncryptionScheme.values()).filter(encryptionScheme -> encryptionScheme.getValue().equals(scheme)).findFirst();
        return encryptionSchemeFound.orElseThrow(() -> new IllegalArgumentException(String.format("Encryption Scheme [%s] not found", scheme)));
    }

    private Cipher getCipher(String transformation) {
        try {
            return Cipher.getInstance(transformation, (Provider)BOUNCY_CASTLE_PROVIDER);
        }
        catch (GeneralSecurityException e) {
            String message = String.format("Cipher [%s] not found", transformation);
            throw new CipherException(message, e);
        }
    }

    private static class DecryptCallback
    extends DecryptStreamCallback {
        private static final byte[] EMPTY_SALT = new byte[0];
        private static final int BLOCK_SIZE_UNDEFINED = 0;
        private final String cipherAlgorithm;
        private final int cipherBlockSize;
        private final PBEKeySpec keySpec;
        private final CompatibilityModeKeyDerivationStrategy keyDerivationStrategy;

        private DecryptCallback(Cipher cipher, PBEKeySpec keySpec, CompatibilityModeKeyDerivationStrategy keyDerivationStrategy) {
            super(cipher, keyDerivationStrategy.getSaltBufferLength());
            this.cipherAlgorithm = cipher.getAlgorithm();
            this.cipherBlockSize = cipher.getBlockSize();
            this.keySpec = keySpec;
            this.keyDerivationStrategy = keyDerivationStrategy;
        }

        @Override
        protected Key getKey(AlgorithmParameterSpec algorithmParameterSpec) {
            SecretKeyFactory secretKeyFactory = this.getSecretKeyFactory();
            try {
                return secretKeyFactory.generateSecret(this.keySpec);
            }
            catch (InvalidKeySpecException e) {
                String message = String.format("Generate Secret Key Algorithm [%s] invalid specification", this.cipherAlgorithm);
                throw new CipherException(message, e);
            }
        }

        @Override
        protected AlgorithmParameterSpec readAlgorithmParameterSpec(ByteBuffer parameterBuffer) {
            byte[] salt = this.readSalt(parameterBuffer);
            return new PBEParameterSpec(salt, this.keyDerivationStrategy.getIterations());
        }

        private byte[] readSalt(ByteBuffer byteBuffer) {
            byte[] salt = CompatibilityModeKeyDerivationStrategy.OPENSSL_EVP_BYTES_TO_KEY == this.keyDerivationStrategy ? this.readSaltOpenSsl(byteBuffer) : this.readSaltStandard(byteBuffer);
            return salt;
        }

        private byte[] readSaltOpenSsl(ByteBuffer byteBuffer) {
            byte[] salt;
            int saltHeaderLength = this.keyDerivationStrategy.getSaltHeader().length;
            byte[] saltHeader = new byte[saltHeaderLength];
            byteBuffer.get(saltHeader);
            if (MessageDigest.isEqual(this.keyDerivationStrategy.getSaltHeader(), saltHeader)) {
                salt = new byte[this.keyDerivationStrategy.getSaltStandardLength()];
                byteBuffer.get(salt);
            } else {
                salt = EMPTY_SALT;
                byteBuffer.rewind();
            }
            return salt;
        }

        private byte[] readSaltStandard(ByteBuffer byteBuffer) {
            int saltLength = this.cipherBlockSize == 0 ? this.keyDerivationStrategy.getSaltStandardLength() : this.cipherBlockSize;
            byte[] salt = new byte[saltLength];
            byteBuffer.get(salt);
            return salt;
        }

        private SecretKeyFactory getSecretKeyFactory() {
            try {
                return SecretKeyFactory.getInstance(this.cipherAlgorithm, (Provider)BOUNCY_CASTLE_PROVIDER);
            }
            catch (NoSuchAlgorithmException e) {
                String message = String.format("Secret Key Factory Algorithm [%s] not found", this.cipherAlgorithm);
                throw new CipherException(message, e);
            }
        }
    }
}

