/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.AbstractEventWriter;
import org.apache.nifi.cdc.mysql.event.BinlogEventInfo;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public abstract class AbstractBinlogEventWriter<T extends BinlogEventInfo>
extends AbstractEventWriter<T> {
    protected void writeJson(T event) throws IOException {
        String gtidSet = event.getBinlogGtidSet();
        if (gtidSet == null) {
            this.jsonGenerator.writeStringField("binlog_filename", event.getBinlogFilename());
            this.jsonGenerator.writeNumberField("binlog_position", event.getBinlogPosition().longValue());
        } else {
            this.jsonGenerator.writeStringField("binlog_gtidset", event.getBinlogGtidSet());
        }
    }

    protected Map<String, String> getCommonAttributes(final long sequenceId, final BinlogEventInfo eventInfo) {
        return new HashMap<String, String>(){
            {
                this.put("cdc.sequence.id", Long.toString(sequenceId));
                this.put("cdc.event.type", eventInfo.getEventType());
                String gtidSet = eventInfo.getBinlogGtidSet();
                if (gtidSet == null) {
                    this.put("binlog.filename", eventInfo.getBinlogFilename());
                    this.put("binlog.position", Long.toString(eventInfo.getBinlogPosition()));
                } else {
                    this.put("binlog.gtidset", gtidSet);
                }
                this.put(CoreAttributes.MIME_TYPE.key(), "application/json");
            }
        };
    }

    public long writeEvent(ProcessSession session, String transitUri, T eventInfo, long currentSequenceId, Relationship relationship) {
        FlowFile flowFile = session.create();
        flowFile = session.write(flowFile, outputStream -> {
            super.startJson(outputStream, (EventInfo)eventInfo);
            this.writeJson(eventInfo);
            super.endJson();
        });
        flowFile = session.putAllAttributes(flowFile, this.getCommonAttributes(currentSequenceId, (BinlogEventInfo)eventInfo));
        session.transfer(flowFile, relationship);
        session.getProvenanceReporter().receive(flowFile, transitUri);
        return currentSequenceId + 1L;
    }
}

