/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.event;

import java.util.List;
import org.apache.nifi.cdc.event.BaseEventInfo;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.TableEventInfo;
import org.apache.nifi.cdc.event.TableInfo;

public class BaseTableEventInfo
extends BaseEventInfo
implements TableEventInfo {
    private String databaseName;
    private String tableName;
    private Long tableId;
    private List<ColumnDefinition> columns;

    public BaseTableEventInfo(TableInfo tableInfo, String eventType, Long timestamp) {
        super(eventType, timestamp);
        if (tableInfo != null) {
            this.databaseName = tableInfo.getDatabaseName();
            this.tableName = tableInfo.getTableName();
            this.tableId = tableInfo.getTableId();
            this.columns = tableInfo.getColumns();
        }
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Long getTableId() {
        return this.tableId;
    }

    @Override
    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    @Override
    public ColumnDefinition getColumnByIndex(int i) {
        try {
            return this.columns.get(i);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return null;
        }
    }
}

