/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.ccda;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.openhealthtools.mdht.uml.cda.CDAPackage;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.ccd.CCDPackage;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;
import org.openhealthtools.mdht.uml.cda.hitsp.HITSPPackage;
import org.openhealthtools.mdht.uml.cda.ihe.IHEPackage;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.w3c.dom.Document;

@DeprecationNotice(reason="Parsing XML elements to FlowFile attributes is not recommend and should be replaced with record-oriented handling")
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"CCDA", "healthcare", "extract", "attributes"})
@CapabilityDescription(value="Extracts information from an Consolidated CDA formatted FlowFile and provides individual attributes as FlowFile attributes. The attributes are named as <Parent> <dot> <Key>. If the Parent is repeating, the naming will be <Parent> <underscore> <Parent Index> <dot> <Key>. For example, section.act_07.observation.name=Essential hypertension")
public class ExtractCCDAAttributes
extends AbstractProcessor {
    private static final char FIELD_SEPARATOR = '@';
    private static final char KEY_VALUE_SEPARATOR = '#';
    private Map<String, Map<String, String>> processMap = new LinkedHashMap<String, Map<String, String>>();
    private JexlEngine jexl = null;
    private JexlContext jexlCtx = null;
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    public static final PropertyDescriptor SKIP_VALIDATION = new PropertyDescriptor.Builder().name("skip-validation").displayName("Skip Validation").description("Whether or not to validate CDA message values").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship if it is properly parsed as CDA and its contents extracted as attributes.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if it cannot be parsed as CDA or its contents extracted as attributes.").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(_relationships);
        ArrayList<PropertyDescriptor> _properties = new ArrayList<PropertyDescriptor>();
        _properties.add(SKIP_VALIDATION);
        this.properties = Collections.unmodifiableList(_properties);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.getLogger().debug("Loading packages");
        StopWatch stopWatch = new StopWatch(true);
        System.setProperty("org.eclipse.emf.ecore.EPackage.Registry.INSTANCE", "org.eclipse.emf.ecore.impl.EPackageRegistryImpl");
        CDAPackage.eINSTANCE.eClass();
        HITSPPackage.eINSTANCE.eClass();
        CCDPackage.eINSTANCE.eClass();
        ConsolPackage.eINSTANCE.eClass();
        IHEPackage.eINSTANCE.eClass();
        stopWatch.stop();
        this.getLogger().debug("Loaded packages in {}", new Object[]{stopWatch.getDuration(TimeUnit.MILLISECONDS)});
        this.jexl = new JexlBuilder().cache(1024).debug(false).silent(true).strict(false).create();
        this.jexlCtx = new MapContext();
        this.getLogger().debug("Loading mappings");
        this.loadMappings();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        this.getLogger().info("Processing CCDA");
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        if (this.processMap.isEmpty()) {
            this.getLogger().error("Process Mapping is not loaded");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        Boolean skipValidation = context.getProperty(SKIP_VALIDATION).asBoolean();
        StopWatch stopWatch = new StopWatch(true);
        ClinicalDocument cd = null;
        try {
            cd = this.loadDocument(session.read(flowFile), skipValidation);
        }
        catch (ProcessException e) {
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        this.getLogger().debug("Loaded document for {} in {}", new Object[]{flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS)});
        this.getLogger().debug("Processing elements");
        this.processElement(null, cd, attributes);
        flowFile = session.putAllAttributes(flowFile, attributes);
        stopWatch.stop();
        this.getLogger().debug("Successfully processed {} in {}", new Object[]{flowFile, stopWatch.getDuration(TimeUnit.MILLISECONDS)});
        if (this.getLogger().isDebugEnabled()) {
            for (Map.Entry entry : attributes.entrySet()) {
                this.getLogger().debug("Attribute: {}={}", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
        session.transfer(flowFile, REL_SUCCESS);
    }

    protected Map<String, Object> processElement(String parent, Object element, Map<String, String> attributes) {
        StopWatch stopWatch = new StopWatch(true);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String name = element.getClass().getName();
        Map<String, String> jexlMap = this.processMap.get(name);
        if (jexlMap == null) {
            this.getLogger().warn("Missing mapping for element " + name);
            return null;
        }
        for (Map.Entry<String, String> entry : jexlMap.entrySet()) {
            this.jexlCtx.set("element", element);
            JexlExpression jexlExpr = this.jexl.createExpression(entry.getValue());
            Object value = jexlExpr.evaluate(this.jexlCtx);
            String key = entry.getKey();
            String prefix = parent != null ? parent + "." + key : key;
            this.addElement(map, prefix, key, value, attributes);
        }
        stopWatch.stop();
        this.getLogger().debug("Processed {} in {}", new Object[]{name, stopWatch.getDuration(TimeUnit.MILLISECONDS)});
        return map;
    }

    protected Map<String, String> addElement(Map<String, Object> map, String prefix, String key, Object value, Map<String, String> attributes) {
        if (value instanceof String) {
            if (value != null && !((String)value).isEmpty()) {
                map.put(key, value);
                attributes.put(prefix, (String)value);
            }
        } else if (value instanceof List) {
            if (value != null && !((List)value).isEmpty()) {
                map.put(key, this.processList(prefix, (List)value, attributes));
            }
        } else if (value != null) {
            map.put(key, this.processElement(prefix, value, attributes));
        }
        return attributes;
    }

    protected List<Object> processList(String key, List value, Map<String, String> attributes) {
        ArrayList<Object> items = new ArrayList<Object>();
        String keyFormat = value.size() > 1 ? "%s_%02d" : "%s";
        for (Object item : value) {
            items.add(this.processElement(String.format(keyFormat, key, items.size() + 1), item, attributes));
        }
        return items;
    }

    protected ClinicalDocument loadDocument(InputStream inputStream, Boolean skipValidation) {
        ClinicalDocument cd = null;
        try {
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            documentProvider.setNamespaceAware(true);
            Document document = documentProvider.parse(inputStream);
            cd = CDAUtil.load((Document)document);
            if (!skipValidation.booleanValue() && !CDAUtil.validate((ClinicalDocument)cd, (CDAUtil.ValidationHandler)new CDAValidationHandler())) {
                this.getLogger().error("Failed to validate CDA document");
                throw new ProcessException("Failed to validate CDA document");
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to load CDA document", (Throwable)e);
            throw new ProcessException("Failed to load CDA document", (Throwable)e);
        }
        return cd;
    }

    protected void loadMappings() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Properties mappings = new Properties();
        try (InputStream is = classloader.getResourceAsStream("mapping.properties");){
            mappings.load(is);
            for (String property : mappings.stringPropertyNames()) {
                String[] variables = StringUtils.split((String)mappings.getProperty(property), (char)'@');
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (String variable : variables) {
                    String[] keyvalue = StringUtils.split((String)variable, (char)'#');
                    map.put(keyvalue[0], keyvalue[1]);
                }
                this.processMap.put(property, map);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to load mappings", (Throwable)e);
            throw new ProcessException("Failed to load mappings", (Throwable)e);
        }
    }

    protected class CDAValidationHandler
    implements CDAUtil.ValidationHandler {
        protected CDAValidationHandler() {
        }

        public void handleError(Diagnostic diagnostic) {
            ExtractCCDAAttributes.this.getLogger().error("ERROR: " + diagnostic.getMessage());
        }

        public void handleWarning(Diagnostic diagnostic) {
            ExtractCCDAAttributes.this.getLogger().warn("WARNING: " + diagnostic.getMessage());
        }

        public void handleInfo(Diagnostic diagnostic) {
            ExtractCCDAAttributes.this.getLogger().info("INFO: " + diagnostic.getMessage());
        }
    }
}

