/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.box.BoxFileInfo;
import org.apache.nifi.processors.box.BoxFileUtils;
import org.apache.nifi.processors.box.BoxFlowFileAttribute;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.PutBoxFile;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"box", "storage"})
@CapabilityDescription(value="Lists files in a Box folder. Each listed file may result in one FlowFile, the metadata being written as FlowFile attributes. Or - in case the 'Record Writer' property is set - the entire result is written as records to a single FlowFile. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data.")
@SeeAlso(value={FetchBoxFile.class, PutBoxFile.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="box.size", description="The size of the file"), @WritesAttribute(attribute="box.timestamp", description="The last modified time of the file")})
@Stateful(scopes={Scope.CLUSTER}, description="The processor stores necessary data to be able to keep track what files have been listed already. What exactly needs to be stored depends on the 'Listing Strategy'.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListBoxFile
extends AbstractListProcessor<BoxFileInfo> {
    public static final PropertyDescriptor FOLDER_ID = new PropertyDescriptor.Builder().name("box-folder-id").displayName("Folder ID").description("The ID of the folder from which to pull list of files.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    public static final PropertyDescriptor RECURSIVE_SEARCH = new PropertyDescriptor.Builder().name("recursive-search").displayName("Search Recursively").description("When 'true', will include list of files from sub-folders. Otherwise, will return only files that are within the folder defined by the 'Folder ID' property.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("min-age").displayName("Minimum File Age").description("The minimum age a file must be in order to be considered; any files younger than this will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor LISTING_STRATEGY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractListProcessor.LISTING_STRATEGY).allowableValues(new AllowableValue[]{BY_TIMESTAMPS, BY_ENTITIES, BY_TIME_WINDOW, NO_TRACKING}).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(BoxClientService.BOX_CLIENT_SERVICE, FOLDER_ID, RECURSIVE_SEARCH, MIN_AGE, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, RECORD_WRITER));
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected Map<String, String> createAttributes(BoxFileInfo entity, ProcessContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (BoxFlowFileAttribute attribute : BoxFlowFileAttribute.values()) {
            Optional.ofNullable(attribute.getValue(entity)).ifPresent(value -> attributes.put(attribute.getName(), (String)value));
        }
        return attributes;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Box Folder [%s]", this.getPath(context));
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return LISTING_STRATEGY.equals((Object)property) || FOLDER_ID.equals((Object)property) || RECURSIVE_SEARCH.equals((Object)property);
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return BoxFileInfo.getRecordSchema();
    }

    protected String getDefaultTimePrecision() {
        return PRECISION_SECONDS.getValue();
    }

    protected List<BoxFileInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode) {
        ArrayList<BoxFileInfo> listing = new ArrayList<BoxFileInfo>();
        String folderId = context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
        Boolean recursive = context.getProperty(RECURSIVE_SEARCH).asBoolean();
        Long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        long createdAtMax = Instant.now().toEpochMilli() - minAge;
        this.listFolder(listing, folderId, recursive, createdAtMax);
        return listing;
    }

    private void listFolder(List<BoxFileInfo> listing, String folderId, Boolean recursive, long createdAtMax) {
        BoxFolder folder = this.getFolder(folderId);
        for (BoxItem.Info itemInfo : folder.getChildren(new String[]{"id", "name", "item_status", "size", "created_at", "modified_at", "content_created_at", "content_modified_at", "path_collection"})) {
            BoxFile.Info info;
            if (itemInfo instanceof BoxFile.Info) {
                info = (BoxFile.Info)itemInfo;
                long createdAt = itemInfo.getCreatedAt().getTime();
                if (createdAt > createdAtMax) continue;
                BoxFileInfo boxFileInfo = new BoxFileInfo.Builder().id(info.getID()).fileName(info.getName()).path(BoxFileUtils.getParentPath((BoxItem.Info)info)).size(info.getSize()).createdTime(info.getCreatedAt().getTime()).modifiedTime(info.getModifiedAt().getTime()).build();
                listing.add(boxFileInfo);
                continue;
            }
            if (!recursive.booleanValue() || !(itemInfo instanceof BoxFolder.Info)) continue;
            info = (BoxFolder.Info)itemInfo;
            this.listFolder(listing, info.getID(), recursive, createdAtMax);
        }
    }

    BoxFolder getFolder(String folderId) {
        return new BoxFolder(this.boxAPIConnection, folderId);
    }

    protected Integer countUnfilteredListing(ProcessContext context) {
        return this.performListing(context, null, AbstractListProcessor.ListingMode.CONFIGURATION_VERIFICATION).size();
    }
}

