/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class BlobInfo
implements Comparable<BlobInfo>,
Serializable,
ListableEntity {
    private static final long serialVersionUID = 1L;
    private static final RecordSchema SCHEMA;
    static final String BLOB_NAME = "blobName";
    static final String BLOB_TYPE = "blobType";
    static final String FILENAME = "filename";
    static final String CONTAINER_NAME = "container";
    static final String LENGTH = "length";
    static final String LAST_MODIFIED = "lastModified";
    static final String ETAG = "etag";
    static final String CONTENT_LANGUAGE = "language";
    static final String CONTENT_TYPE = "contentType";
    static final String PRIMARY_URI = "primaryUri";
    static final String SECONDARY_URI = "secondaryUri";
    private final String primaryUri;
    private final String secondaryUri;
    private final String contentType;
    private final String contentLanguage;
    private final String etag;
    private final long lastModifiedTime;
    private final long length;
    private final String blobType;
    private final String blobName;
    private final String containerName;

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getPrimaryUri() {
        return this.primaryUri;
    }

    public String getSecondaryUri() {
        return this.secondaryUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getLength() {
        return this.length;
    }

    public String getBlobType() {
        return this.blobType;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(PRIMARY_URI, this.getPrimaryUri());
        values.put(SECONDARY_URI, this.getSecondaryUri());
        values.put(CONTENT_TYPE, this.getContentType());
        values.put(CONTENT_LANGUAGE, this.getContentLanguage());
        values.put(CONTAINER_NAME, this.getContainerName());
        values.put(BLOB_NAME, this.getBlobName());
        values.put(FILENAME, this.getName());
        values.put(ETAG, this.getEtag());
        values.put(LAST_MODIFIED, this.getLastModifiedTime());
        values.put(LENGTH, this.getLength());
        values.put(BLOB_TYPE, this.getBlobType());
        return new MapRecord(SCHEMA, values);
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.etag == null ? 0 : this.etag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlobInfo other = (BlobInfo)obj;
        return !(this.etag == null ? other.etag != null : !this.etag.equals(other.etag));
    }

    @Override
    public int compareTo(BlobInfo o) {
        return this.etag.compareTo(o.etag);
    }

    private BlobInfo(Builder builder) {
        this.primaryUri = builder.primaryUri;
        this.secondaryUri = builder.secondaryUri;
        this.contentType = builder.contentType;
        this.contentLanguage = builder.contentLanguage;
        this.containerName = builder.containerName;
        this.etag = builder.etag;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.length = builder.length;
        this.blobType = builder.blobType;
        this.blobName = builder.blobName;
    }

    public String getName() {
        String primaryUri = this.getPrimaryUri();
        return primaryUri.substring(primaryUri.lastIndexOf(47) + 1);
    }

    public String getIdentifier() {
        return this.getPrimaryUri();
    }

    public long getTimestamp() {
        return this.getLastModifiedTime();
    }

    public long getSize() {
        return this.length;
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(BLOB_NAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(BLOB_TYPE, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(CONTAINER_NAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(LENGTH, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(LAST_MODIFIED, RecordFieldType.TIMESTAMP.getDataType(), false));
        recordFields.add(new RecordField(ETAG, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(CONTENT_LANGUAGE, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(CONTENT_TYPE, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(PRIMARY_URI, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(SECONDARY_URI, RecordFieldType.STRING.getDataType()));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private String primaryUri;
        private String secondaryUri;
        private String contentType;
        private String contentLanguage;
        private String etag;
        private long lastModifiedTime;
        private long length;
        private String blobType;
        private String containerName;
        private String blobName;

        public Builder primaryUri(String primaryUri) {
            this.primaryUri = primaryUri;
            return this;
        }

        public Builder secondaryUri(String secondaryUri) {
            this.secondaryUri = secondaryUri;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder lastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder blobType(String blobType) {
            this.blobType = blobType;
            return this;
        }

        public Builder blobName(String blobName) {
            this.blobName = blobName;
            return this;
        }

        public BlobInfo build() {
            return new BlobInfo(this);
        }
    }
}

