/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.cosmos.document;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.cosmos.document.AzureCosmosDBUtils;
import org.apache.nifi.services.azure.cosmos.AzureCosmosDBConnectionService;

public abstract class AbstractAzureCosmosDBProcessor
extends AbstractProcessor {
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are written to Cosmos DB are routed to this relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be written to Cosmos DB are routed to this relationship").build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("All input FlowFiles that are part of a successful are routed to this relationship").build();
    static final PropertyDescriptor CONNECTION_SERVICE = new PropertyDescriptor.Builder().name("azure-cosmos-db-connection-service").displayName("Cosmos DB Connection Service").description("If configured, the controller service used to obtain the connection string and access key").required(false).identifiesControllerService(AzureCosmosDBConnectionService.class).build();
    static final PropertyDescriptor DATABASE_NAME = new PropertyDescriptor.Builder().name("azure-cosmos-db-name").displayName("Cosmos DB Name").description("The database name or id. This is used as the namespace for document collections or containers").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor CONTAINER_ID = new PropertyDescriptor.Builder().name("azure-cosmos-db-container-id").displayName("Cosmos DB Container ID").description("The unique identifier for the container").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor PARTITION_KEY = new PropertyDescriptor.Builder().name("azure-cosmos-db-partition-key").displayName("Cosmos DB Partition Key").description("The partition key used to distribute data among servers").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("charactor-set").displayName("Charactor Set").description("The Character Set in which the data is encoded").required(false).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    static final List<PropertyDescriptor> descriptors;
    private CosmosClient cosmosClient;
    private CosmosContainer container;
    private AzureCosmosDBConnectionService connectionService;

    @OnScheduled
    public void onScheduled(ProcessContext context) throws CosmosException {
        ComponentLog logger = this.getLogger();
        if (context.getProperty(CONNECTION_SERVICE).isSet()) {
            this.connectionService = (AzureCosmosDBConnectionService)context.getProperty(CONNECTION_SERVICE).asControllerService(AzureCosmosDBConnectionService.class);
            this.cosmosClient = this.connectionService.getCosmosClient();
        } else {
            String selectedConsistency;
            String uri = context.getProperty(AzureCosmosDBUtils.URI).getValue();
            String accessKey = context.getProperty(AzureCosmosDBUtils.DB_ACCESS_KEY).getValue();
            ConsistencyLevel clevel = switch (selectedConsistency = context.getProperty(AzureCosmosDBUtils.CONSISTENCY).getValue()) {
                case "STRONG" -> ConsistencyLevel.STRONG;
                case "CONSISTENT_PREFIX" -> ConsistencyLevel.CONSISTENT_PREFIX;
                case "SESSION" -> ConsistencyLevel.SESSION;
                case "BOUNDED_STALENESS" -> ConsistencyLevel.BOUNDED_STALENESS;
                case "EVENTUAL" -> ConsistencyLevel.EVENTUAL;
                default -> ConsistencyLevel.SESSION;
            };
            if (this.cosmosClient != null) {
                this.onStopped();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Creating CosmosClient");
            }
            this.createCosmosClient(uri, accessKey, clevel);
        }
        this.getCosmosDocumentContainer(context);
        this.doPostActionOnSchedule(context);
    }

    protected void createCosmosClient(String uri, String accessKey, ConsistencyLevel clevel) {
        this.cosmosClient = new CosmosClientBuilder().endpoint(uri).key(accessKey).consistencyLevel(clevel).buildClient();
    }

    protected abstract void doPostActionOnSchedule(ProcessContext var1);

    protected void getCosmosDocumentContainer(ProcessContext context) throws CosmosException {
        String databaseName = context.getProperty(DATABASE_NAME).getValue();
        String containerID = context.getProperty(CONTAINER_ID).getValue();
        String partitionKey = context.getProperty(PARTITION_KEY).getValue();
        CosmosDatabaseResponse databaseResponse = this.cosmosClient.createDatabaseIfNotExists(databaseName);
        CosmosDatabase database = this.cosmosClient.getDatabase(databaseResponse.getProperties().getId());
        CosmosContainerProperties containerProperties = new CosmosContainerProperties(containerID, "/" + partitionKey);
        CosmosContainerResponse containerResponse = database.createContainerIfNotExists(containerProperties);
        this.container = database.getContainer(containerResponse.getProperties().getId());
    }

    @OnStopped
    public final void onStopped() {
        ComponentLog logger = this.getLogger();
        if (this.connectionService == null && this.cosmosClient != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing CosmosClient");
            }
            try {
                this.container = null;
                this.cosmosClient.close();
            }
            catch (CosmosException e) {
                logger.error("Error closing Cosmos DB client due to {}", new Object[]{e.getMessage(), e});
            }
            finally {
                this.cosmosClient = null;
            }
        }
    }

    protected String getURI(ProcessContext context) {
        if (this.connectionService != null) {
            return this.connectionService.getURI();
        }
        return context.getProperty(AzureCosmosDBUtils.URI).getValue();
    }

    protected String getAccessKey(ProcessContext context) {
        if (this.connectionService != null) {
            return this.connectionService.getAccessKey();
        }
        return context.getProperty(AzureCosmosDBUtils.DB_ACCESS_KEY).getValue();
    }

    protected String getConsistencyLevel(ProcessContext context) {
        if (this.connectionService != null) {
            return this.connectionService.getConsistencyLevel();
        }
        return context.getProperty(AzureCosmosDBUtils.CONSISTENCY).getValue();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        Object msg;
        ArrayList<ValidationResult> retVal = new ArrayList<ValidationResult>();
        boolean connectionServiceIsSet = context.getProperty(CONNECTION_SERVICE).isSet();
        boolean uriIsSet = context.getProperty(AzureCosmosDBUtils.URI).isSet();
        boolean accessKeyIsSet = context.getProperty(AzureCosmosDBUtils.DB_ACCESS_KEY).isSet();
        boolean databaseIsSet = context.getProperty(DATABASE_NAME).isSet();
        boolean collectionIsSet = context.getProperty(CONTAINER_ID).isSet();
        boolean partitionIsSet = context.getProperty(PARTITION_KEY).isSet();
        if (connectionServiceIsSet && (uriIsSet || accessKeyIsSet)) {
            msg = String.format("If connection service is used for DB connection, none of %s and %s should be set", AzureCosmosDBUtils.URI.getDisplayName(), AzureCosmosDBUtils.DB_ACCESS_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().valid(false).explanation((String)msg).build());
        } else if (!(connectionServiceIsSet || uriIsSet && accessKeyIsSet)) {
            msg = String.format("If connection service is not used for DB connection, both %s and %s should be set", AzureCosmosDBUtils.URI.getDisplayName(), AzureCosmosDBUtils.DB_ACCESS_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().valid(false).explanation((String)msg).build());
        }
        if (!databaseIsSet) {
            msg = DATABASE_NAME.getDisplayName() + " must be set.";
            retVal.add(new ValidationResult.Builder().valid(false).explanation((String)msg).build());
        }
        if (!collectionIsSet) {
            msg = CONTAINER_ID.getDisplayName() + " must be set.";
            retVal.add(new ValidationResult.Builder().valid(false).explanation((String)msg).build());
        }
        if (!partitionIsSet) {
            msg = PARTITION_KEY.getDisplayName() + " must be set.";
            retVal.add(new ValidationResult.Builder().valid(false).explanation((String)msg).build());
        }
        return retVal;
    }

    protected CosmosClient getCosmosClient() {
        return this.cosmosClient;
    }

    protected void setCosmosClient(CosmosClient cosmosClient) {
        this.cosmosClient = cosmosClient;
    }

    protected CosmosContainer getContainer() {
        return this.container;
    }

    protected void setContainer(CosmosContainer container) {
        this.container = container;
    }

    protected AzureCosmosDBConnectionService getConnectionService() {
        return this.connectionService;
    }

    protected void setConnectionService(AzureCosmosDBConnectionService connectionService) {
        this.connectionService = connectionService;
    }

    static {
        ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
        _temp.add(CONNECTION_SERVICE);
        _temp.add(AzureCosmosDBUtils.URI);
        _temp.add(AzureCosmosDBUtils.DB_ACCESS_KEY);
        _temp.add(AzureCosmosDBUtils.CONSISTENCY);
        _temp.add(DATABASE_NAME);
        _temp.add(CONTAINER_ID);
        _temp.add(PARTITION_KEY);
        descriptors = Collections.unmodifiableList(_temp);
    }
}

