/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsType;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob", "credentials"})
@CapabilityDescription(value="Provides credentials for Azure Blob processors using Azure Blob Storage client library v12.")
public class AzureStorageCredentialsControllerService_v12
extends AbstractControllerService
implements AzureStorageCredentialsService_v12 {
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ACCOUNT_NAME).description("The storage account name.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor ENDPOINT_SUFFIX = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ENDPOINT_SUFFIX).displayName("Endpoint Suffix").description("Storage accounts in public Azure always use a common FQDN suffix. Override this endpoint suffix with a different suffix in certain circumstances (like Azure Stack or non-public Azure regions).").required(true).defaultValue("blob.core.windows.net").expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor CREDENTIALS_TYPE = new PropertyDescriptor.Builder().name("credentials-type").displayName("Credentials Type").description("Credentials type to be used for authenticating to Azure").required(true).allowableValues(new AllowableValue[]{AzureStorageCredentialsType.ACCOUNT_KEY.getAllowableValue(), AzureStorageCredentialsType.SAS_TOKEN.getAllowableValue(), AzureStorageCredentialsType.MANAGED_IDENTITY.getAllowableValue(), AzureStorageCredentialsType.SERVICE_PRINCIPAL.getAllowableValue()}).defaultValue(AzureStorageCredentialsType.SAS_TOKEN.name()).build();
    public static final PropertyDescriptor ACCOUNT_KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ACCOUNT_KEY).displayName("Account Key").description("The storage account key. This is an admin-like password providing access to every container in this account. It is recommended one uses Shared Access Signature (SAS) token instead for fine-grained control with policies.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.ACCOUNT_KEY.getAllowableValue()}).build();
    public static final PropertyDescriptor SAS_TOKEN = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.PROP_SAS_TOKEN).description("Shared Access Signature token, including the leading '?'. Specify either SAS token (recommended) or Account Key.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.SAS_TOKEN.getAllowableValue()}).build();
    public static final PropertyDescriptor MANAGED_IDENTITY_CLIENT_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.MANAGED_IDENTITY.getAllowableValue()}).build();
    public static final PropertyDescriptor SERVICE_PRINCIPAL_TENANT_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID).required(true).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.SERVICE_PRINCIPAL.getAllowableValue()}).build();
    public static final PropertyDescriptor SERVICE_PRINCIPAL_CLIENT_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID).required(true).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.SERVICE_PRINCIPAL.getAllowableValue()}).build();
    public static final PropertyDescriptor SERVICE_PRINCIPAL_CLIENT_SECRET = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET).required(true).dependsOn(CREDENTIALS_TYPE, new AllowableValue[]{AzureStorageCredentialsType.SERVICE_PRINCIPAL.getAllowableValue()}).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME, ENDPOINT_SUFFIX, CREDENTIALS_TYPE, ACCOUNT_KEY, SAS_TOKEN, MANAGED_IDENTITY_CLIENT_ID, SERVICE_PRINCIPAL_TENANT_ID, SERVICE_PRINCIPAL_CLIENT_ID, SERVICE_PRINCIPAL_CLIENT_SECRET));
    private ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    public AzureStorageCredentialsDetails_v12 getCredentialsDetails() {
        String accountName = this.context.getProperty(ACCOUNT_NAME).getValue();
        String endpointSuffix = this.context.getProperty(ENDPOINT_SUFFIX).getValue();
        AzureStorageCredentialsType credentialsType = AzureStorageCredentialsType.valueOf((String)this.context.getProperty(CREDENTIALS_TYPE).getValue());
        switch (credentialsType) {
            case ACCOUNT_KEY: {
                String accountKey = this.context.getProperty(ACCOUNT_KEY).getValue();
                return AzureStorageCredentialsDetails_v12.createWithAccountKey((String)accountName, (String)endpointSuffix, (String)accountKey);
            }
            case SAS_TOKEN: {
                String sasToken = this.context.getProperty(SAS_TOKEN).getValue();
                return AzureStorageCredentialsDetails_v12.createWithSasToken((String)accountName, (String)endpointSuffix, (String)sasToken);
            }
            case MANAGED_IDENTITY: {
                String managedIdentityClientId = this.context.getProperty(MANAGED_IDENTITY_CLIENT_ID).getValue();
                return AzureStorageCredentialsDetails_v12.createWithManagedIdentity((String)accountName, (String)endpointSuffix, (String)managedIdentityClientId);
            }
            case SERVICE_PRINCIPAL: {
                String servicePrincipalTenantId = this.context.getProperty(SERVICE_PRINCIPAL_TENANT_ID).getValue();
                String servicePrincipalClientId = this.context.getProperty(SERVICE_PRINCIPAL_CLIENT_ID).getValue();
                String servicePrincipalClientSecret = this.context.getProperty(SERVICE_PRINCIPAL_CLIENT_SECRET).getValue();
                return AzureStorageCredentialsDetails_v12.createWithServicePrincipal((String)accountName, (String)endpointSuffix, (String)servicePrincipalTenantId, (String)servicePrincipalClientId, (String)servicePrincipalClientSecret);
            }
        }
        throw new IllegalArgumentException("Unhandled credentials type: " + credentialsType);
    }
}

