/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob", "queue", "credentials"})
@CapabilityDescription(value="Defines credentials for Azure Storage processors. Uses Account Name with Account Key or Account Name with SAS Token.")
public class AzureStorageCredentialsControllerService
extends AbstractControllerService
implements AzureStorageCredentialsService {
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().name(AzureStorageUtils.ACCOUNT_NAME.getName()).displayName(AzureStorageUtils.ACCOUNT_NAME.getDisplayName()).description("The storage account name. There are certain risks in allowing the account name to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g., by strictly controlling the policies governing provenance for this processor). In addition, the provenance repositories may be put on encrypted disk partitions.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).sensitive(true).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME, AzureStorageUtils.ACCOUNT_KEY, AzureStorageUtils.PROP_SAS_TOKEN, AzureStorageUtils.ENDPOINT_SUFFIX));
    private ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String accountKey = validationContext.getProperty(AzureStorageUtils.ACCOUNT_KEY).getValue();
        String sasToken = validationContext.getProperty(AzureStorageUtils.PROP_SAS_TOKEN).getValue();
        if (StringUtils.isBlank((CharSequence)accountKey) && StringUtils.isBlank((CharSequence)sasToken)) {
            results.add(new ValidationResult.Builder().subject("AzureStorageCredentialsControllerService").valid(false).explanation("either " + AzureStorageUtils.ACCOUNT_KEY.getDisplayName() + " or " + AzureStorageUtils.PROP_SAS_TOKEN.getDisplayName() + " is required").build());
        } else if (StringUtils.isNotBlank((CharSequence)accountKey) && StringUtils.isNotBlank((CharSequence)sasToken)) {
            results.add(new ValidationResult.Builder().subject("AzureStorageCredentialsControllerService").valid(false).explanation("cannot set both " + AzureStorageUtils.ACCOUNT_KEY.getDisplayName() + " and " + AzureStorageUtils.PROP_SAS_TOKEN.getDisplayName()).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    public AzureStorageCredentialsDetails getStorageCredentialsDetails(Map<String, String> attributes) {
        return AzureStorageUtils.createStorageCredentialsDetails((PropertyContext)this.context, attributes);
    }
}

