/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.eventhub.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public final class AzureEventHubUtils {
    public static final AllowableValue AZURE_ENDPOINT = new AllowableValue(".servicebus.windows.net", "Azure", "Servicebus endpoint for general use");
    public static final AllowableValue AZURE_CHINA_ENDPOINT = new AllowableValue(".servicebus.chinacloudapi.cn", "Azure China", "Servicebus endpoint for China");
    public static final AllowableValue AZURE_GERMANY_ENDPOINT = new AllowableValue(".servicebus.cloudapi.de", "Azure Germany", "Servicebus endpoint for Germany");
    public static final AllowableValue AZURE_US_GOV_ENDPOINT = new AllowableValue(".servicebus.usgovcloudapi.net", "Azure US Government", "Servicebus endpoint for US Government");
    public static final PropertyDescriptor POLICY_PRIMARY_KEY = new PropertyDescriptor.Builder().name("Shared Access Policy Primary Key").description("The primary key of the shared access policy").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).sensitive(true).required(false).build();
    public static final PropertyDescriptor USE_MANAGED_IDENTITY = new PropertyDescriptor.Builder().name("use-managed-identity").displayName("Use Azure Managed Identity").description("Choose whether or not to use the managed identity of Azure VM/VMSS").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor SERVICE_BUS_ENDPOINT = new PropertyDescriptor.Builder().name("Service Bus Endpoint").description("To support namespaces not in the default windows.net domain.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{AZURE_ENDPOINT, AZURE_CHINA_ENDPOINT, AZURE_GERMANY_ENDPOINT, AZURE_US_GOV_ENDPOINT}).defaultValue(AZURE_ENDPOINT.getValue()).required(true).build();

    public static List<ValidationResult> customValidate(PropertyDescriptor accessPolicyDescriptor, PropertyDescriptor policyKeyDescriptor, ValidationContext context) {
        ArrayList<ValidationResult> retVal = new ArrayList<ValidationResult>();
        boolean accessPolicyIsSet = context.getProperty(accessPolicyDescriptor).isSet();
        boolean policyKeyIsSet = context.getProperty(policyKeyDescriptor).isSet();
        boolean useManagedIdentity = context.getProperty(USE_MANAGED_IDENTITY).asBoolean();
        if (useManagedIdentity && (accessPolicyIsSet || policyKeyIsSet)) {
            String msg = String.format("('%s') and ('%s' with '%s') fields cannot be set at the same time.", USE_MANAGED_IDENTITY.getDisplayName(), accessPolicyDescriptor.getDisplayName(), POLICY_PRIMARY_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
        } else if (!(useManagedIdentity || accessPolicyIsSet && policyKeyIsSet)) {
            String msg = String.format("either('%s') or (%s with '%s') must be set", USE_MANAGED_IDENTITY.getDisplayName(), accessPolicyDescriptor.getDisplayName(), POLICY_PRIMARY_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
        }
        return retVal;
    }

    public static Map<String, String> getApplicationProperties(Map<String, Object> eventProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (eventProperties != null) {
            for (Map.Entry<String, Object> property : eventProperties.entrySet()) {
                properties.put(String.format("eventhub.property.%s", property.getKey()), property.getValue().toString());
            }
        }
        return properties;
    }
}

