/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor_v12;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageConflictResolutionStrategy;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={ListAzureBlobStorage_v12.class, FetchAzureBlobStorage_v12.class, DeleteAzureBlobStorage_v12.class})
@CapabilityDescription(value="Puts content into a blob on Azure Blob Storage. The processor uses Azure Blob Storage client library v12.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure Blob Storage container"), @WritesAttribute(attribute="azure.blobname", description="The name of the blob on Azure Blob Storage"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location of the blob"), @WritesAttribute(attribute="azure.etag", description="ETag of the blob"), @WritesAttribute(attribute="azure.blobtype", description="Type of the blob (either BlockBlob, PageBlob or AppendBlob)"), @WritesAttribute(attribute="mime.type", description="MIME Type of the content"), @WritesAttribute(attribute="lang", description="Language code for the content"), @WritesAttribute(attribute="azure.timestamp", description="Timestamp of the blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob"), @WritesAttribute(attribute="azure.error.code", description="Error code reported during blob operation"), @WritesAttribute(attribute="azure.ignored", description="When Conflict Resolution Strategy is 'ignore', this property will be true/false depending on whether the blob was ignored.")})
public class PutAzureBlobStorage_v12
extends AbstractAzureBlobProcessor_v12 {
    public static final PropertyDescriptor CREATE_CONTAINER = new PropertyDescriptor.Builder().name("create-container").displayName("Create Container").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("Specifies whether to check if the container exists and to automatically create it if it does not. Permission to list containers is required. If false, this check is not made, but the Put operation will fail if the container does not exist.").build();
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("conflict-resolution-strategy").displayName("Conflict Resolution Strategy").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).allowableValues(AzureStorageConflictResolutionStrategy.class).defaultValue(AzureStorageConflictResolutionStrategy.FAIL_RESOLUTION.getValue()).description("Specifies whether an existing blob will have its contents replaced upon conflict.").build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(STORAGE_CREDENTIALS_SERVICE, AzureStorageUtils.CONTAINER, CREATE_CONTAINER, CONFLICT_RESOLUTION, BLOB_NAME, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        boolean createContainer = context.getProperty(CREATE_CONTAINER).asBoolean();
        String blobName = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        AzureStorageConflictResolutionStrategy conflictResolution = AzureStorageConflictResolutionStrategy.valueOf((String)context.getProperty(CONFLICT_RESOLUTION).getValue());
        long startNanos = System.nanoTime();
        try {
            BlobServiceClient storageClient = this.getStorageClient();
            BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
            if (createContainer && !containerClient.exists()) {
                containerClient.create();
            }
            BlobClient blobClient = containerClient.getBlobClient(blobName);
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            HashMap<String, String> attributes = new HashMap<String, String>();
            this.applyStandardBlobAttributes(attributes, blobClient);
            boolean ignore = conflictResolution == AzureStorageConflictResolutionStrategy.IGNORE_RESOLUTION;
            try {
                if (conflictResolution != AzureStorageConflictResolutionStrategy.REPLACE_RESOLUTION) {
                    blobRequestConditions.setIfNoneMatch("*");
                }
                try (InputStream rawIn = session.read(flowFile);){
                    BlobParallelUploadOptions blobParallelUploadOptions = new BlobParallelUploadOptions(FluxUtil.toFluxByteBuffer((InputStream)rawIn));
                    blobParallelUploadOptions.setRequestConditions(blobRequestConditions);
                    blobClient.uploadWithResponse(blobParallelUploadOptions, null, Context.NONE);
                    this.applyBlobMetadata(attributes, blobClient);
                    if (ignore) {
                        attributes.put("azure.ignored", "false");
                    }
                }
            }
            catch (BlobStorageException e) {
                BlobErrorCode errorCode = e.getErrorCode();
                flowFile = session.putAttribute(flowFile, "azure.error.code", e.getErrorCode().toString());
                if (errorCode == BlobErrorCode.BLOB_ALREADY_EXISTS && ignore) {
                    this.getLogger().info("Blob already exists: remote blob not modified. Transferring {} to success", new Object[]{flowFile});
                    attributes.put("azure.ignored", "true");
                }
                throw e;
            }
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            String transitUri = (String)attributes.get("azure.primaryUri");
            session.getProvenanceReporter().send(flowFile, transitUri, transferMillis);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to create blob on Azure Blob Storage", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

