/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.ListAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.PutAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={PutAzureDataLakeStorage.class, DeleteAzureDataLakeStorage.class, ListAzureDataLakeStorage.class})
@CapabilityDescription(value="Fetch the provided file from Azure Data Lake Storage")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.datalake.storage.statusCode", description="The HTTP error code (if available) from the failed operation"), @WritesAttribute(attribute="azure.datalake.storage.errorCode", description="The Azure Data Lake Storage moniker of the failed operation"), @WritesAttribute(attribute="azure.datalake.storage.errorMessage", description="The Azure Data Lake Storage error message from the failed operation")})
public class FetchAzureDataLakeStorage
extends AbstractAzureDataLakeStorageProcessor {
    public static final PropertyDescriptor RANGE_START = new PropertyDescriptor.Builder().name("range-start").displayName("Range Start").description("The byte position at which to start reading from the object. An empty value or a value of zero will start reading at the beginning of the object.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor RANGE_LENGTH = new PropertyDescriptor.Builder().name("range-length").displayName("Range Length").description("The number of bytes to download from the object, starting from the Range Start. An empty value or a value that extends beyond the end of the object will read to the end of the object.").addValidator(StandardValidators.createDataSizeBoundsValidator((long)1L, (long)Long.MAX_VALUE)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor NUM_RETRIES = new PropertyDescriptor.Builder().name("number-of-retries").displayName("Number of Retries").description("The number of automatic retries to perform if the download fails.").addValidator(StandardValidators.createLongValidator((long)0L, (long)Integer.MAX_VALUE, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).defaultValue("0").build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ADLS_CREDENTIALS_SERVICE, FILESYSTEM, DIRECTORY, FILE, RANGE_START, RANGE_LENGTH, NUM_RETRIES, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        try {
            long rangeStart = context.getProperty(RANGE_START).isSet() ? context.getProperty(RANGE_START).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue() : 0L;
            Long rangeLength = context.getProperty(RANGE_LENGTH).isSet() ? Long.valueOf(context.getProperty(RANGE_LENGTH).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue()) : null;
            int numRetries = context.getProperty(NUM_RETRIES).isSet() ? context.getProperty(NUM_RETRIES).evaluateAttributeExpressions(flowFile).asInteger() : 0;
            FileRange fileRange = new FileRange(rangeStart, rangeLength);
            DownloadRetryOptions retryOptions = new DownloadRetryOptions();
            retryOptions.setMaxRetryRequests(numRetries);
            String fileSystem = FetchAzureDataLakeStorage.evaluateFileSystemProperty(context, flowFile);
            String directory = FetchAzureDataLakeStorage.evaluateDirectoryProperty(context, flowFile);
            String fileName = FetchAzureDataLakeStorage.evaluateFileNameProperty(context, flowFile);
            DataLakeServiceClient storageClient = this.getStorageClient((PropertyContext)context, flowFile);
            DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
            DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(directory);
            DataLakeFileClient fileClient = directoryClient.getFileClient(fileName);
            if (fileClient.getProperties().isDirectory().booleanValue()) {
                throw new ProcessException(FILE.getDisplayName() + " (" + fileName + ") points to a directory. Full path: " + fileClient.getFilePath());
            }
            flowFile = session.write(flowFile, os -> fileClient.readWithResponse(os, fileRange, retryOptions, null, false, null, Context.NONE));
            session.getProvenanceReporter().modifyContent(flowFile);
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, fileClient.getFileUrl(), transferMillis);
        }
        catch (DataLakeStorageException e) {
            this.getLogger().error("Failure to fetch file from Azure Data Lake Storage", (Throwable)e);
            flowFile = session.putAttribute(flowFile, "azure.datalake.storage.statusCode", String.valueOf(e.getStatusCode()));
            flowFile = session.putAttribute(flowFile, "azure.datalake.storage.errorCode", e.getErrorCode());
            flowFile = session.putAttribute(flowFile, "azure.datalake.storage.errorMessage", e.getMessage());
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
        catch (Exception e) {
            this.getLogger().error("Failure to fetch file from Azure Data Lake Storage", (Throwable)e);
            flowFile = session.putAttribute(flowFile, "azure.datalake.storage.errorMessage", e.getMessage());
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

